package com.yeejoin.amos.boot.module.tzs.biz.utils;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.tzs.api.vo.AlertCalledVo;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;


/**
 * @author fengwang
 * @date 2021-08-05.
 */
@Component
public class AlertBeanDtoVoUtils {

    /**
     * 将警情记录实体类转换为Vo
     *
     * @param source  实体类
     * @return Vo类
     */
    public static AlertCalledVo convertAlertCalledDtoToVo( AlertCalledDto source) {
        // 判断source是否为空
        if (source == null) {
            return null;
        }
        try {
            // 创建新的对象实例
            AlertCalledVo target = new AlertCalledVo();
            // 把原对象数据拷贝到新对象
            BeanUtils.copyProperties(source, target);
            // 返回新对象
            return target;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 将警情记录实体类转换为Vo
     *
     * @param source  实体类
     * @return Vo类
     */
    public static AlertCalledVo convertAlertCalledToVo( AlertCalled source) {
        // 判断source是否为空
        if (source == null) {
            return null;
        }
        try {
            // 创建新的对象实例
            AlertCalledVo target = new AlertCalledVo();
            // 把原对象数据拷贝到新对象
            BeanUtils.copyProperties(source, target);
            // 返回新对象
            return target;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }



    /**
     * 将AlertCalled转换为IPage<AlertCalledVo>
     *
     * @param page 原分页对象
     * @return 转换后的Vo
     */
    public static IPage<AlertCalledVo> alertCalledIPageVo(IPage<AlertCalled> page) {
        return page.convert(item -> {
            try {
                return convertAlertCalledToVo(item);
            } catch (Exception e) {
                return null;
            }
        });
    }

}
