package com.yeejoin.equipmanage.common.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author ZeHua Li
 * @date 2020/10/29 14:11
 * @since v2.0
 */
@Data
@TableName("wl_equipment_specific")
@ApiModel(value = "EquipmentSpecific对象", description = "具体设备二维码等信息")
public class EquipmentSpecific extends BaseEntity {

    @ApiModelProperty(value = "设备id")
    @TableField("equipment_detail_id")
    private Long equipmentDetailId;

    @ApiModelProperty(value = "二维码")
    @TableField("qr_code")
    private String qrCode;

    @ApiModelProperty(value = "管理方式(默认单件)")
    @TableField("single")
    private Boolean single;

    @ApiModelProperty(value = "所属系统")
    @TableField("system_id")
    private String systemId;

    @ApiModelProperty(value = "物联编码")
    @TableField("iot_code")
    private String iotCode;

    @ApiModelProperty(value = "批量录入数量")
    @TableField(exist = false)
    private Integer num;

    @ApiModelProperty(value = "单位编码")
    @TableField("org_code")
    private String orgCode;

    @ApiModelProperty(value = "设备编码")
    @TableField("code")
    private String code;

    @ApiModelProperty(value = "录入方式")
    @TableField("input_way")
    private Integer inputWay;

    @ApiModelProperty(value = "所属单位id(来源于平台)")
    @TableField("agency_id")
    private String agencyId;
    
    @ApiModelProperty(value = "所属单位名称(来源于平台)")
    @TableField("agency_name")
    private String agencyName;

    @ApiModelProperty(value = "所属队伍id(来源于平台)")
    @TableField("team_id")
    private String teamId;

    @ApiModelProperty(value = "队伍名称(冗余字段来源于平台)")
    @TableField("team_name")
    private String teamName;
    
    @ApiModelProperty(value = "实时指标名称")
    @TableField("realtime_iot_index_name")
    private String realtimeIotIndexName;
    
    @ApiModelProperty(value = "实时指标编码")
    @TableField("realtime_iot_index_key")
    private String realtimeIotIndexKey;
    
    @ApiModelProperty(value = "实时指标值")
    @TableField("realtime_iot_index_value")
    private String realtimeIotIndexValue;
    
    @ApiModelProperty(value = "实时指标id（wl_equipment_specific_index_id）")
    @TableField("realtime_iot_es_index_id")
    private Long realtimeIotEsIndexId;
    
    @ApiModelProperty(value = "指标id（wl_equipment_index_id）")
    @TableField("realtime_iot_index_id")
    private Long realtimeIotIndexId;

    @ApiModelProperty(value = "实时指标更新时间")
    @TableField("realtime_iot_index_update_date")
    private Date realtimeIotIndexUpdateDate;
    
    @ApiModelProperty(value = "完整二维码")
    @TableField(exist = false)
    private String fullqrCode;

    @TableField(exist = false)
    private Stock stock;

    @TableField(exist = false)
    private StockDetail stockDetail;


    //新加

    @ApiModelProperty(value = "机构/部门名称")
    @TableField("biz_org_name")
    private String bizOrgName;

    @ApiModelProperty(value = "机构编码")
    @TableField("biz_org_code")
    private String bizOrgCode;


    /**
     * 所属部门
     */
    private Long departmentId;

    /**
     * 物理区域id,数据来源于wl_area
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Long areaId;

    /**
     * 设备名称
     */
    private String name;

    /**
     * 设备位置
     */
    private String position;

    /**
     * 设备detail编码
     */
    private String equipmentCode;

    /**
     * 存放位置冗余字段
     */
    private Long warehouseStructureId;

    @ApiModelProperty(value = "告警状态")
    @TableField(exist = false)
    private Integer status;

    @ApiModelProperty(value = "系统名称")
    @TableField(exist = false)
    private String systemName;

    @ApiModelProperty(value = "设备值说明")
    @TableField("value_label")
    private String valueLabel;

    @ApiModelProperty(value = "质保信息")
    @TableField("warranty_info")
    private String warrantyInfo;

    @ApiModelProperty(value = "质保周期")
    @TableField("warranty_period")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date warrantyPeriod;
}
