package com.yeejoin.precontrol.common.service.hk;


import com.yeejoin.precontrol.common.entity.hk.model.dto.HKRequestDto;
import com.yeejoin.precontrol.common.vo.hik.Online;

import java.util.List;

/**
 * @Author: songLei
 * @Description: 海康平台业务接口类
 * @Date: 2021/4/29 11:47
 * @Version: 1.0
 */
public interface HkPlatFormService {
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 获取监控点预览取流URL
     * @Date 2021/4/29 11:58
     */
    Object getMonitoringPointPreviewURL(HKRequestDto dto);
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 分页获取监控点资源
     * 获取监控点列表接口可用来全量同步监控点信息，返回结果分页展示。
     * @Date 2021年4月30日10:06:42
     */
    Object getMonitoringPointPage(HKRequestDto dto);
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 根据区域编号获取下级监控点列表
     * 根据指定的区域编号获取该区域下的监控点列表信息，返回结果分页展示。
     * 注：返回的监控点不包括下级区域的。
     * @Date 2021年4月30日10:20:11
     */
    Object getMonitoringPointChildren(HKRequestDto dto);
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 根据编号获取监控点详细信息
     * 获取单个监控点信息是指根据监控点唯一标识来获取指定的监控点信息。
     * @Date 2021/4/30 10:47
     */
    Object getMonitoringPointDetails(HKRequestDto dto);
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 获取监控点回放取流URL
     * 1.平台正常运行；平台已经添加过设备和监控点信息。
     * 2.平台需要安装mgc取流服务。
     * 3.三方通过openAPI获取到监控点数据，依据自身业务开发监控点导航界面。
     * 4.调用本接口获取回放取流URL，协议类型包括：rtsp、rtmp、hls（只支持云存储）。
     * 5.通过开放平台的开发包进行录像回放或者使用可以播放标准的RTST, RTMP, HLS流的播放器进行录像回放。（开发包使用说明参考开发包的使用说明文档）
     * @Date 2021/4/30 16:59
     */
    Object getMonitoringPointPlayBack(HKRequestDto dto);
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 批量添加区域
     * 支持区域的批量添加。
     * 三方可以自行指定区域的唯一标识，也可以由ISC平台自行生成。
     * @param dto
     * @Date 2021/5/7 16:04
     */
    Object batchAddRegion(HKRequestDto dto);
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 该接口用于设置监控点的预置点信息，
     * 若参数传已经存在的预置点编号，则可修改预置点信息
     * @param dto
     * @Date 2021/5/7 16:04
     */
    Object setAddition(HKRequestDto dto);
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 获取根区域信息
     * @Date 2021年9月15日17:26:13
     */
    Object getRootZone();
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 分页获取区域列表
     * @Date 2021年9月15日17:26:13
     */
    Object getRegions (HKRequestDto dto);
    /**
     * @Author songLei
     * @Version 1.0
     * @Description 获取视频在线状态
     * @Date 2021年9月15日17:26:13
     */
    List<Online> getIsOnline(HKRequestDto dto);
}
