package com.yeejoin.precontrol.common.service.impl;

import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.precontrol.common.entity.PersonCondition;
import com.yeejoin.precontrol.common.entity.UserRegistration;
import com.yeejoin.precontrol.common.exception.BaseException;
import com.yeejoin.precontrol.common.mapper.PersonConditionMapper;
import com.yeejoin.precontrol.common.service.IPersonConditionService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 人员条件表 服务实现类
 *
 * @author duanwei
 * @date 2021-02-05
 */
@Service
public class PersonConditionServiceImpl extends ServiceImpl<PersonConditionMapper, PersonCondition>
		implements IPersonConditionService {

	@Override
	public PersonCondition saveOne(UserRegistration userRegistration, Long examId, Long knowledgeTaskId) {
		FeignClientResult<AgencyUserModel> userModel = Privilege.agencyUserClient
				.queryByUserId(String.valueOf(userRegistration.getUserId()));
		Long personId = null;
		if (userModel.getResult() != null) {
			personId = userModel.getResult().getSequenceNbr();
		} else {
			throw new BaseException("账号不存在,userId: " + userRegistration.getUserId());
		}
		PersonCondition personCondition = new PersonCondition();
		personCondition.setPersonId(personId);
		personCondition.setExamId(examId);
		personCondition.setExamStatus(0);
		personCondition.setKnowledgeTaskId(knowledgeTaskId);
		personCondition.setKnowledgeStatus(0);
		this.remove(new LambdaQueryWrapper<PersonCondition>().eq(PersonCondition::getPersonId, personId));
		this.save(personCondition);
		return personCondition;
	}
}
