package com.yeejoin.precontrol.common.vo;


import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class PersonExcelVo {
    private Long id;
    @Excel(name = "姓名")
    private String name;
    @Excel(name = "性别", replace = {"男_0", "女_1", "_null"})
    private String sex;
    @Excel(name = "生日", importFormat = "yyyy/MM/dd", exportFormat = "yyyy/MM/dd")
    private Date birthday;
    @Excel(name = "年龄")
    private Integer age;
    @Excel(name = "民族")
    private String folkKey;
    @Excel(name = "政治面貌")
    private String politicCountenance;
    @Excel(name = "身高")
    private Long height;
    @Excel(name = "体重")
    private Long weight;
    @Excel(name = "电话")
    private String phone;
    @Excel(name = "应急电话")
    private String emergencyPhone;
    @Excel(name = "证件编号")
    private String idNumber;
    @Excel(name = "证件类型", replace = {"身份证 _0", "_null"})
    private String idType;
//    private String nativePlace;
//    @Excel(name = "籍贯")
//    private String nativePlaceName;
//
//    private String employPlace;
//    @Excel(name = "用工来源所在地")
//    @TableField(exist = false)
//    private String employPlaceName;

    @Excel(name = "户籍地址")
    private String address;
    @Excel(name = "现个人住址")
    private String presentAddress;
    @Excel(name = "参加工作时间", importFormat = "yyyy/MM/dd", exportFormat = "yyyy/MM/dd")
    private Date workTime;
    @Excel(name = "是否特殊工种", replace = {"否_0", "是_1", "_null"})
    private String isSpecialWork;
    @Excel(name = "工种名称/特殊工种名称")
    private String workName;
    @Excel(name = "技能鉴定工种")
    private String workTypeKey;
    @Excel(name = "专业技术资格")
    private String professionalTechnologyKey;
    @Excel(name = "专业技术资格等级")
    private String professionalTechnologyLevelKey;
    @Excel(name = "技能等级")
    private String skillLevelKey;
    @Excel(name = "初始学历")
    private String initialEducationKey;
    @Excel(name = "现学历")
    private String currentEducationKey;
    @Excel(name = "现学历学校名称")
    private String currentSchool;
    @Excel(name = "现学历所学专业")
    private String currentMajor;
    @Excel(name = "岗位执业资格证书")
    private String professionalQualificationCertificate;
    @Excel(name = "岗位职业资格证书")
    private String professionalCertificationPosition;
//    @Excel(name = "考核成绩")
    private String examineScore;
//    @Excel(name = "是否合格", replace = {"不合格_0", "合格_1", "_null"})
    private String qualified;
    @Excel(name = "综合评分")
    private String compositeScore;
    @Excel(name = "进入本单位工作时间", importFormat = "yyyy/MM/dd", exportFormat = "yyyy/MM/dd")
    private Date companyWorkTime;
    //@Excel(name = "所在单位id")
    private Long companyId;
    @Excel(name = "所在单位")
    private String companyName;
    //@Excel(name = "所在项目id")
    private String projectId;
    @Excel(name = "所在项目")
    private String projectName;
    //@Excel(name = "部门/班组")
    private String departmentId;
    @Excel(name = "部门/班组")
    private String departmentName;
    @Excel(name = "工作所在地", replace = {"国内_0", "国外_1", "_null"})
    private String workPlaceKey;
    //@Excel(name = "工作所在地")
    //private String workPlaceKeyName;
    @Excel(name = "岗位名称")
    private String postName;
    
    @Excel(name = "农民工用工形式")
    private String contractName;
    @Excel(name = "劳动合同类型", replace = {"合同制_0", "劳务派遣_1", "临时协议_2", "其他_3", "_null"})
    private String contractTypeKey;
    // @Excel(name = "劳动合同主体单位id")
    private Long contractCompanyId;
    @Excel(name = "劳动合同主体单位名称")
    private String contractCompanyName;
    @Excel(name = "合同期限", replace = {"永久_0", "非永久_1", "_null"})
    private String expiryTypeKey;
    @Excel(name = "合同开始时间", importFormat = "yyyy/MM/dd", exportFormat = "yyyy/MM/dd")
    private Date startTime;
    @Excel(name = "合同结束时间", importFormat = "yyyy/MM/dd", exportFormat = "yyyy/MM/dd")
    private Date endTime;
    
    private int useful;
    
    @Excel(name = "体检单位")
    private String examineCompany;
    @Excel(name = "体检时间", importFormat = "yyyy/MM/dd", exportFormat = "yyyy/MM/dd")
    private Date examineDate;
    @Excel(name = "健康状态", replace = {"健康_0", "亚健康_1", "不健康_2", "其他_3", "_null"})
    private String healthStatus;

    @Excel(name = "投保单位")
    private String insureCompany;
    @Excel(name = "投保时间", importFormat = "yyyy/MM/dd", exportFormat = "yyyy/MM/dd")
    private Date insureDate;
    @Excel(name = "投保额度")
    private String insurePremium;
    @Excel(name = "保障期限")
    private String insurePeriod;

    private String insurePeriodStart;
    private String insurePeriodEnd;


    @Excel(name = "证件类别")
    private String certificateTypeKey;
    @Excel(name = "证件名称")
    private String certificateNameKey;
    @Excel(name = "取证项目")
    private String certificateProject;
    @Excel(name = "发证机关")
    private String issuingAuthority;
    @Excel(name = "证书编号")
    private String certificateNumber;
    @Excel(name = "取证时间", importFormat = "yyyy/MM/dd", exportFormat = "yyyy/MM/dd")
    private Date certificateObtainTime;
    @Excel(name = "有效期限（年）")
    private String expireDate;
    @Excel(name = "证书等级")
    private String certificateLevel;
    @Excel(name = "工号")
    private String jobNumber;

}
