package com.yeejoin.equipmanage.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.yeejoin.equipmanage.common.dto.AnalysisReportLogDto;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.entity.AnalysisReportLog;
import com.yeejoin.equipmanage.common.enums.AnalysisReportEnum;
import com.yeejoin.equipmanage.common.vo.ReportResponse;
import com.yeejoin.equipmanage.service.IAnalysisReportLogService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 报告流水表
 *
 * @author duanwei
 * @date 2021-05-26
 */
@RestController
@Api(tags = "报告流水表Api")
@RequestMapping(value = "/analysis-report-log", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class AnalysisReportLogController extends AbstractBaseController {

	@Value("${equip.report.url}")
	private String reportUrlBase;

	// 工具栏中，显示第几个按钮,从左到右，可由逗号隔开显示多个
	private String showButton = "6";

	@Lazy
	@Autowired
	IAnalysisReportLogService iAnalysisReportLogService;

	/**
	 * 分页接口
	 */
	@GetMapping(value = "/listPage")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
	public IPage<AnalysisReportLog> listPage(Page page, @RequestParam Integer reportType,
			@RequestParam String startDate, @RequestParam String endDate) throws ParseException {
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
		AnalysisReportLog analysisReportLog = new AnalysisReportLog();
		analysisReportLog.setReportType(reportType);
		if (startDate != null && !"".equals(startDate) && endDate != null && !"".equals(endDate)) {
			Date startDate1 = simpleDateFormat.parse(startDate);
			Date endDate1 = simpleDateFormat.parse(endDate);
			analysisReportLog.setEndDate(endDate1);
			analysisReportLog.setStartDate(startDate1);
		}
		return iAnalysisReportLogService.listPage(page, analysisReportLog);
	}

	@GetMapping(value = "/showReport")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查看报表", notes = "查看报表")
	public ReportResponse showReport(@RequestParam Integer reportType, @RequestParam String startDate,
			@RequestParam String endDate, @RequestParam String createDate) {
		ReportResponse reportResponse = new ReportResponse();
		if (startDate != null && !"".equals(startDate) && endDate != null && !"".equals(endDate) && createDate != null
				&& !"".equals(createDate)) {
			String urlType = AnalysisReportEnum.getOne(reportType).getReportUrl();
			// _t= 表示工具栏中，显示第几个按钮 1,3
			String url = reportUrlBase + urlType + "&createDate=" + createDate + "&startDate=" + startDate + "&endDate="
					+ endDate + "&_t=" + showButton;
			// 获取公司名称
			ReginParams reginParams = getSelectedOrgInfo();
			String companyName = this.getCompanyName(reginParams);
			reportResponse.setReportUrl(url);
			reportResponse.setCompanyName(companyName);
		}

		return reportResponse;
	}



	@GetMapping(value = "/iotReportPage")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
	public IPage<AnalysisReportLogDto> iotReportPage(Page page, @RequestParam Integer reportType,
												  @ApiParam(value = "开始日期", required = false) @RequestParam(required = false) @DateTimeFormat(pattern="yyyy-MM-dd")Date startDate,
												  @ApiParam(value = "结束日期", required = false) @RequestParam(required = false) @DateTimeFormat(pattern="yyyy-MM-dd")Date endDate,
												  @ApiParam(value = "换流站编码", required = false) @RequestParam(required = false) String stationCode) {
		AnalysisReportLogDto dto = new AnalysisReportLogDto();
		dto.setStartDate(startDate);
		dto.setEndDate(endDate);
		dto.setReportType(reportType);
		ReginParams reginParams = getSelectedOrgInfo();

		dto.setStationCode(reginParams.getPersonIdentity().getCompanyBizOrgCode());

		return iAnalysisReportLogService.iotReportPage(page, dto);
	}
}
