package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;

import com.yeejoin.equipmanage.common.entity.dto.MonitorEventDto;
import com.yeejoin.equipmanage.service.impl.MonitorEventService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 
 * <pre>
 * 前端控制器
 * </pre>
 *
 * @author gwb
 * @version $Id: MonitorEventController.java, v 0.1 2021年9月13日 上午11:27:07 gwb
 *          Exp $
 */

@RestController
@Api(tags = "在岗监测事件Api")
@RequestMapping(value = "/monitorEvent")
public class MonitorEventController extends AbstractBaseController {

	@Autowired
	private MonitorEventService monitorEventService;

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "编辑监测事件")
	@RequestMapping(value = "/{id}", method = RequestMethod.PUT)
	public ResponseModel<MonitorEventDto> updateAgency(@RequestBody MonitorEventDto model,
			@PathVariable("id") Long id) {
		model.setId(id);
        ReginParams reginParams = getSelectedOrgInfo();
        model.setDisposalUserName(reginParams.getPersonIdentity().getPersonName());
		return ResponseHelper.buildResponse(monitorEventService.udpateMonitorEvent(model, this.getUserInfo()));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "获取单个监测事件信息")
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	public ResponseModel<MonitorEventDto> seleteOne(@PathVariable("id") Long id) {
		return ResponseHelper.buildResponse(monitorEventService.queryById(id));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "分页查询监测事件信息")
	@RequestMapping(value = "/page", method = RequestMethod.GET)
	public ResponseModel<Page<MonitorEventDto>> queryPage(
			@RequestParam(value = "eventType", required = false) String eventType,
			@RequestParam(value = "eventState", required = false) String eventState,
			@RequestParam(value = "videoCode", required = false) String videoCode,
			@RequestParam(value = "videoName", required = false) String videoName,
			@RequestParam(value = "eventDate", required = false) String eventDate,
			@RequestParam(value = "startDate", required = false) String startDate,
			@RequestParam(value = "endDate", required = false) String endDate,
			@RequestParam(value = "current") int current, @RequestParam(value = "size") int size) throws Exception {

		Page<MonitorEventDto> page = new Page<MonitorEventDto>();
		page.setCurrent(current);
		page.setSize(size);

		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		Date[] date = null;
		Date startDateTime = null;
		Date endDateTime = null;
		if (!ValidationUtil.isEmpty(startDate) && !ValidationUtil.isEmpty(endDate)) {
			startDateTime = dateFormat.parse(startDate);
			endDateTime = dateFormat.parse(endDate);
			date = new Date[] { startDateTime, endDateTime };
		}
		if (!ValidationUtil.isEmpty(eventDate)) {

			startDateTime = dateFormat.parse(StringUtils.trimToNull(eventDate).substring(0, 10) + " 00:00:00");
			endDateTime = dateFormat.parse(StringUtils.trimToNull(eventDate).substring(0, 10) + " 23:59:59");

			date = new Date[] { startDateTime, endDateTime };
		}
		return ResponseHelper
				.buildResponse(monitorEventService.queryPage(page, eventType, eventState, videoCode, date));
	}

}
