package com.yeejoin.equipmanage.service;

import com.yeejoin.equipmanage.common.vo.IotDataVO;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author GaoJianqiang
 * @date 2023/02/15 16:20
 */
public interface IPressurePumpService {


    /**
     * redis缓存物联采集数据，内部读取JSON配置指定有效期
     *
     * @param iotDatalist
     * @param topic
     */
    void saveDataToRedis(List<IotDataVO> iotDatalist, String topic);

    /**
     * 根据nameKey，模糊查询所有的redis缓存数据
     * @param infoCode
     * @param nameKey
     * @param iotCode
     * @return
     */
    List<IotDataVO> getDataToRedis(String infoCode, String nameKey, String iotCode);

    /**
     * 获取指标配置JSON信息集合
     * @param code
     */
    List<Map> getNameKeyInfoList(String code);

    /**
     * 获取所有稳压泵最近一次启停间隔，min
     * @param dataList
     * @param nowStrLong
     */
    long getAllPressurePumpStartStopInterval(List<IotDataVO> dataList, String nowStrLong);

    /**
     * 获取稳压泵一定时间内启动频率或次数
     * @param hour
     * @param dateNow
     */
    int getAllPressurePumpStartFrequency(double hour, Date dateNow);

    /**
     * 获取稳压泵最近一次启停时长，min
     * @param dataList
     * @param nowStrLong
     */
    long getAllPressurePumpStartStopDuration(List<IotDataVO> dataList, String nowStrLong);

    /**
     * 获取稳压泵指定启泵前 minutes 分钟，管网压力差绝对值
     * @param dataList
     * @param dataPipeList
     * @param minutes
     * @return
     */
    double getAllPressurePumpPipePressureDiff(List<IotDataVO> dataList, List<IotDataVO> dataPipeList, String minutes);

    /**
     * 根据指标，获取物联top数据，influxdb
     * @param top
     * @param productKey
     * @param deviceName
     * @param key
     * @param fieldKey
     */
    List<Map<String, String>> getIotTopSingleField(String top, String productKey, String deviceName, String key, String fieldKey);

    /**
     * 根据时间范围，获取redis指定指标或指定指标设备的缓存数据
     * @param infoCode
     * @param nameKey
     * @param iotCode
     * @param startDate
     * @param endDate
     */
    List<IotDataVO> getDataToRedisByDateBetween(String infoCode, String nameKey, String iotCode, Date startDate, Date endDate);

    /**
     * 根据时间范围获取iot物联数据集合
     * @param startTime
     * @param endTime
     * @param prefix
     * @param suffix
     * @param key
     * @param fieldKey
     */
    List<Map<String, String>> getIotCommonListData(String startTime, String endTime, String prefix, String suffix, String key, String fieldKey);

}
