package com.yeejoin.amos.patrol.business.dao.repository;

import com.yeejoin.amos.patrol.dao.entity.Route;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository("iRouteDao")
public interface IRouteDao extends BaseDao<Route, Long> {

    @Modifying
    @Transactional
    @Query(value = "UPDATE p_route SET is_delete = 1 WHERE id IN (?1)", nativeQuery = true)
    void delRouteById(List<Long> ids);

    long countAllByOrgCodeAndName(String orgCode, String name);

    Route findByOriginalId(String originalId);

    @Query(value = "select * from p_route where original_id in ?1 and is_delete =0", nativeQuery = true)
    List<Route> listByOriginalIds(List<String> originalIds);

    @Query(value = "select * from p_route where `name` = ?1 and is_delete =0", nativeQuery = true)
    List<Route> getListByName(String name);
}
