package com.yeejoin.amos.boot.module.jczs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 安全追溯-压力容器
 *
 * @author cpp
 * @date 2023-04-06 15:21:21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="paramVessel", description="压力容器技术参数")
public class EquipTechParamVesselModel extends BaseDto {
    private static final long serialVersionUID = 1L;

            @ApiModelProperty(value = "")
        private String instanceId;
            @ApiModelProperty(value = "")
        private String status;
            @ApiModelProperty(value = "额定质量")
        private BigDecimal ratedQuality;
            @ApiModelProperty(value = "使用环境温度")
        private BigDecimal ambientTemperature;
            @ApiModelProperty(value = "型号")
        private String modelNumber;
            @ApiModelProperty(value = "数量")
        private Integer num;
            @ApiModelProperty(value = "单瓶容积")
        private BigDecimal singleBottleVolume;
            @ApiModelProperty(value = "总容积")
        private BigDecimal totalVolume;
            @ApiModelProperty(value = "充装介质")
        private String chargingMedium;
            @ApiModelProperty(value = "规格")
        private String specification;
            @ApiModelProperty(value = "外径")
        private BigDecimal outsideDiameter;
            @ApiModelProperty(value = "壁厚")
        private BigDecimal wallThickness;
            @ApiModelProperty(value = "长度")
        private BigDecimal length;
            @ApiModelProperty(value = "公称工作压力")
        private BigDecimal nominalWorkingPressure;
            @ApiModelProperty(value = "材料（瓶体）")
        private String bottleBody;
            @ApiModelProperty(value = "材料（端塞）")
        private String endPlug;
            @ApiModelProperty(value = "材料（管路）")
        private String piping;
            @ApiModelProperty(value = "无损检测方法（气瓶）")
        private String qpLossless;
            @ApiModelProperty(value = "无损检测方法（管路）")
        private String glLossless;
            @ApiModelProperty(value = "无损检测比例（气瓶）")
        private BigDecimal qpRatio;
            @ApiModelProperty(value = "无损检测比例（管路）")
        private BigDecimal glRatio;
            @ApiModelProperty(value = "耐压试验压力（气瓶）")
        private BigDecimal qpPressure;
            @ApiModelProperty(value = "耐压试验压力（管路）")
        private BigDecimal glPressure;
            @ApiModelProperty(value = "气密性试验压力（气瓶）")
        private BigDecimal qpAirTightness;
            @ApiModelProperty(value = "气密性试验压力（管路）")
        private BigDecimal glAirTightness;
            @ApiModelProperty(value = "气体置换后压力")
        private BigDecimal displacementPressure;
            @ApiModelProperty(value = "瓶体内含氧量")
        private BigDecimal oxygen;
            @ApiModelProperty(value = "瓶体内含氧量")
        private String heatTreatmentMethod;
            @ApiModelProperty(value = "热处理温度")
        private BigDecimal qpHeatTreatmentTemperature;
            @ApiModelProperty(value = "气瓶安装位置")
        private String installationPosition;
            @ApiModelProperty(value = "容器容积")
        private BigDecimal containerVolume;
            @ApiModelProperty(value = "容器内径")
        private BigDecimal pressureVesselDiameter;
            @ApiModelProperty(value = "容器高(长)")
        private BigDecimal height;
            @ApiModelProperty(value = "材料（筒体(球壳)）")
        private String materialCylinderShell;
            @ApiModelProperty(value = "材料（封头）")
        private String pressureMaterialHead;
            @ApiModelProperty(value = "材料（衬里）")
        private String pressureMaterialLining;
            @ApiModelProperty(value = "材料（夹套）")
        private String materialJacket;
            @ApiModelProperty(value = "厚度（筒体(球壳)）")
        private BigDecimal thickness;
            @ApiModelProperty(value = "厚度（封头）")
        private BigDecimal fixedHead;
            @ApiModelProperty(value = "厚度（衬里）")
        private BigDecimal fixedLining;
            @ApiModelProperty(value = "厚度（夹套）")
        private BigDecimal fixedJacket;
            @ApiModelProperty(value = "容器自重")
        private BigDecimal selfWeight;
            @ApiModelProperty(value = "盛装介质重量")
        private BigDecimal mediumWeight;
            @ApiModelProperty(value = "设计压力（壳程）")
        private BigDecimal pressureHousingPath;
            @ApiModelProperty(value = "设计压力（管程）")
        private BigDecimal pressurePipe;
            @ApiModelProperty(value = "设计压力（夹套）")
        private BigDecimal pressureJacket;
            @ApiModelProperty(value = "设计温度（壳程）")
        private BigDecimal temperatureShell;
            @ApiModelProperty(value = "设计温度（管程）")
        private BigDecimal temperaturePipe;
            @ApiModelProperty(value = "设计温度（夹套）")
        private BigDecimal temperatureJacket;
            @ApiModelProperty(value = "最高允许工作压力（壳程）")
        private BigDecimal maxPressureShell;
            @ApiModelProperty(value = "最高允许工作压力（管程）")
        private BigDecimal maxPressurePipe;
            @ApiModelProperty(value = "最高允许工作压力（夹套）")
        private BigDecimal maxPressureJacket;
            @ApiModelProperty(value = "介质（壳程）")
        private String mediumShell;
            @ApiModelProperty(value = "介质（管程）")
        private String mediumPipe;
            @ApiModelProperty(value = "介质（夹套）")
        private String mediumJacket;
            @ApiModelProperty(value = "主体结构型式")
        private String mainStructureType;
            @ApiModelProperty(value = "支座型式")
        private String support;
            @ApiModelProperty(value = "安装型式")
        private String installation;
            @ApiModelProperty(value = "保温绝热方式")
        private String insulation;
            @ApiModelProperty(value = "无损检测方法")
        private String checkLossless;
            @ApiModelProperty(value = "耐压试验种类")
        private String withstandVoltage;
            @ApiModelProperty(value = "泄漏试验种类")
        private String leakage;
            @ApiModelProperty(value = "耐压试验压力")
        private BigDecimal withstandPressureTest;
            @ApiModelProperty(value = "泄漏试验压力")
        private BigDecimal leakPressure;
            @ApiModelProperty(value = "容器型号")
        private String container;
            @ApiModelProperty(value = "罐车编号")
        private String carNum;
            @ApiModelProperty(value = "容积")
        private BigDecimal volume;
            @ApiModelProperty(value = "最大充装量")
        private BigDecimal maxFill;
            @ApiModelProperty(value = "设计压力")
        private BigDecimal designPressure;
            @ApiModelProperty(value = "设计温度")
        private BigDecimal designTemperature;
            @ApiModelProperty(value = "工作压力")
        private BigDecimal workingPressure;
            @ApiModelProperty(value = "工作温度")
        private BigDecimal workTemperature;
            @ApiModelProperty(value = "材料（筒体）")
        private String materialCylinder;
            @ApiModelProperty(value = "厚度（筒体）")
        private BigDecimal thicknessCylinder;
            @ApiModelProperty(value = "腐蚀裕量")
        private BigDecimal corrosionMargin;
            @ApiModelProperty(value = "介质")
        private String medium;
            @ApiModelProperty(value = "氧舱品种")
        private String oxygenChamber;
            @ApiModelProperty(value = "额定进舱人数")
        private Integer ratedEntryCapacity;
            @ApiModelProperty(value = "主体结构")
        private String chamberMain;
            @ApiModelProperty(value = "压力")
        private BigDecimal chamberPressure;
            @ApiModelProperty(value = "温度")
        private BigDecimal temperature;
            @ApiModelProperty(value = "压力介质")
        private BigDecimal pressureMedium;
            @ApiModelProperty(value = "人均舱容")
        private BigDecimal perCapitaCabinCapacity;
          
            @ApiModelProperty(value = "固定安全附件")
        private String fixedSafetyAccessory;
            @ApiModelProperty(value = "气瓶")
        private String gasCylinder;
            @ApiModelProperty(value = "气瓶安全附件")
        private String gasCylinderAccessories;

    
}
