package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.changeRegistrationReform;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.common.biz.event.CommonPublisher;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.dto.PipelineChangeItemDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgChangeRegistrationReform;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 改造变更登记编辑处理器
 */
@Component
public class ChangeRegistrationReformDataChangeHandler extends DefaultBizDataChangeHandler<BaseBizDataChangeEvent> {

    private final ChangeRegistrationReformEditUpdateService changeRegistrationReformEditUpdateService;

    protected ChangeRegistrationReformDataChangeHandler(CommonPublisher routerEventPublisher, ApplicationContext applicationContext, ChangeRegistrationReformEditUpdateService changeRegistrationReformEditUpdateService) {
        super(routerEventPublisher, applicationContext);
        this.changeRegistrationReformEditUpdateService = changeRegistrationReformEditUpdateService;
    }

    @Override
    public String canHandleBizType() {
        return BusinessTypeEnum.JG_RENOVATION_REGISTRATION.name();
    }

    @Override
    public Set<String> getEqs(String applyNo) {
        JgChangeRegistrationReform jgChangeRegistrationReform = changeRegistrationReformEditUpdateService.getMainService().getOne(new LambdaQueryWrapper<JgChangeRegistrationReform>().eq(JgChangeRegistrationReform::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr, JgChangeRegistrationReform::getAuditStatus, JgChangeRegistrationReform::getProjectContraptionId));
        Set<String> eqs = changeRegistrationReformEditUpdateService.getEqsByApplyNo(applyNo);
        // 已完成是查询eq表+本业务增减的管道
        if (jgChangeRegistrationReform.getAuditStatus().equals(FlowStatusEnum.TO_BE_FINISHED.getName()) && StringUtils.isNotEmpty(jgChangeRegistrationReform.getProjectContraptionId())) {
            List<String> newRecords = changeRegistrationReformEditUpdateService.getCommonEquipDataProcessService().getNewPipelineRecordsOfOneBiz(jgChangeRegistrationReform.getSequenceNbr() + "", changeRegistrationReformEditUpdateService.getRegisterReformBackupManager());
            List<String> exists = new ArrayList<>(eqs);
            return Stream.concat(newRecords.stream(), exists.stream()).collect(Collectors.toSet());
        }
        // 管道时根据不同的状态进行查询records
        return eqs;
    }

    @Override
    public Boolean beforeCheck(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        return Boolean.TRUE;
    }

    @Override
    public void preSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        // 记录增减日志
        changeRegistrationReformEditUpdateService.backupOPipelineData(applyNo, model);
    }

    @Override
    public List<FieldChangeMeta> postSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData, List<FieldChangeMeta> allChangeColumns, Map<String, List<PipelineChangeItemDto>> pipelineChangeItemMap) {
        List<FieldChangeMeta> bizEditColumns = new ArrayList<>();
        // 更新eq表、管道纳管状态、使用登记证；改更新本次新增、编辑的管道record集合到流水表
        changeRegistrationReformEditUpdateService.updateBizInfo(bizId, allChangeColumns, applyNo, model, pipelineChangeItemMap);
        return bizEditColumns;
    }


    @Override
    public Boolean bizIsFinished(String applyNo) {
        JgChangeRegistrationReform jgChangeRegistrationReform = changeRegistrationReformEditUpdateService.getMainService().getOne(new LambdaQueryWrapper<JgChangeRegistrationReform>().eq(JgChangeRegistrationReform::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr, JgChangeRegistrationReform::getAuditStatus));
        return jgChangeRegistrationReform.getAuditStatus().equals(FlowStatusEnum.TO_BE_FINISHED.getName());
    }


    @Override
    public Set<String> getProjectContraptionIds(String applyNo) {
        Set<String> projectContraptionIds = new HashSet<>();
        JgChangeRegistrationReform registrationReform = changeRegistrationReformEditUpdateService.getOneByApplyNo(applyNo);
        projectContraptionIds.add(registrationReform.getProjectContraptionId());
        projectContraptionIds.remove(null);
        projectContraptionIds.remove("");
        return projectContraptionIds;
    }


    /**
     * 管道专用-判断数据是实时落库，还是先存到json
     *
     * @param applyNo 单据号
     * @return 是否需要临时存储
     */
    @Override
    public Boolean requiresTemporarySave(String applyNo) {
        return !bizIsFinished(applyNo);
    }

    /**
     * 管道专用
     * 临时存储的json 管道
     *
     * @param applyNo 申请单号
     * @return 暂存的管道列表
     */
    @Override
    public List<PipelineChangeItemDto> getsTemporaryData(String applyNo) {
        return changeRegistrationReformEditUpdateService.getsTemporaryData(applyNo);
    }

}
