package com.yeejoin.amos.boot.module.jg.biz.edit.typeHandler;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.typeHandler.TypeHandler;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 管道压力级别处理器
 */
@Component("pieLineLevelTypeHandler")
public class PieLineLevelTypeHandler implements TypeHandler<String> {

    private final DataDictionaryServiceImpl dataDictionaryService;

    private Map<String, String> cache;

    private Map<String, String> nameCodeMapCache;

    protected PieLineLevelTypeHandler(DataDictionaryServiceImpl dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    @PostConstruct
    private void init() {
        List<DataDictionary> dataDictionary = dataDictionaryService.getDataDictionaryMapper().selectList(new LambdaQueryWrapper<DataDictionary>().in(DataDictionary::getType, Arrays.asList("8200", "8100", "8300")));
        cache = dataDictionary.stream().collect(Collectors.toMap(DataDictionary::getCode, DataDictionary::getName));
        nameCodeMapCache = dataDictionary.stream().collect(Collectors.toMap(DataDictionary::getName, DataDictionary::getCode));
    }


    @Override
    public String handle(String value) {
        return cache.getOrDefault(value, value);
    }

    public String getCodeByName(String name) {
        return nameCodeMapCache.getOrDefault(name, name);
    }
}
