package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.common.restful.utils.ResponseHelper;
import com.yeejoin.amos.api.common.restful.utils.ResponseModel;
import com.yeejoin.amos.api.openapi.face.model.InspectionModel;
import com.yeejoin.amos.api.openapi.face.model.InspectionModelList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.HashMap;
import java.util.Map;

/**
 * 
 * <pre>
 * 特种设备检验对接
 * </pre>
 *
 * @author gwb
 * @version $Id: InspectionController.java, v 0.1 2021年11月8日 下午6:47:54 gwb Exp $
 */
@RestController
@RequestMapping(value = "/v1/inspection")
@Api(tags = "inspection-特种设备检验对接")
public class InspectionController
{
	private static final  Logger logger = LogManager.getLogger(InspectionController.class);
	
	@SuppressWarnings("rawtypes")
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "设备检验数据上传")
	@RequestMapping(value = "sendData", method = RequestMethod.POST)
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> multUploadInspectionData (
			@RequestBody String inspectionModelData) throws Exception 
	{
		
		logger.info(inspectionModelData);
		JSONObject jsonobject = JSONObject.fromObject(inspectionModelData);

		 Map<String, Class> classMap = new HashMap<String, Class>();
		 classMap.put("data", InspectionModel.class);
		
		 InspectionModelList inspectionModelList =  (InspectionModelList)JSONObject.toBean(jsonobject,InspectionModelList.class,classMap);
		return ResponseHelper.buildResponse("");
	}

}
