package com.yeejoin.equipmanage.common.utils;


import com.yeejoin.equipmanage.common.exception.errorEnum.BaseExceptionEnum;
import lombok.Data;

import java.io.Serializable;


/**
 * @description: 异常通用返回类
 * @author: duanwei
 * @create: 2020-05-28 13:57
 **/
@Data
public class ExceptionResult<T> implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer code;
    private String result;
    private String message;
    private T obj;

    public static boolean isSuccess(ExceptionResult<?> response) {
        return response != null && BaseExceptionEnum.SUCCESS.getCode().equals(response.getCode());
    }

    public ExceptionResult() {
        this.code = BaseExceptionEnum.SUCCESS.getCode();
        this.message = BaseExceptionEnum.SUCCESS.getMsg();
    }

    public ExceptionResult(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public ExceptionResult(T obj) {
        this.code = BaseExceptionEnum.SUCCESS.getCode();
        this.message = BaseExceptionEnum.SUCCESS.getMsg();
        this.obj = obj;
    }

}

