package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.common.restful.utils.ResponseHelper;
import com.yeejoin.amos.api.common.restful.utils.ResponseModel;
import com.yeejoin.amos.api.openapi.face.model.*;
import com.yeejoin.amos.api.openapi.face.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "/cylinder")
@Api(tags = "cylinder-气瓶数据对接")
public class CylinderController {
	private static final Logger logger = LogManager.getLogger(CylinderController.class);
	@Autowired
	private TmCylinderUnitService cylinderUnitService;
	@Autowired
	private TmCylinderFillingCheckService cylinderFillingCheckService;
	@Autowired
	private TmCylinderFillingExamineService cylinderFillingExamineService;
	@Autowired
	private TmCylinderFillingRecordService cylinderFillingRecordService;
	@Autowired
	private TmCylinderFillingService cylinderFillingService;
	@Autowired
	private TmCylinderInfoService cylinderInfoService;
	@Autowired
	private TmCylinderInspectionService cylinderInspectionService;
	@Autowired
	private TmCylinderTagsService cylinderTagsService;
	@Autowired
	private CylinderFillingDataValidationService cylinderFillingDataValidationService;
	@Autowired
	TmCylinderFillingMessageService cylinderFillingMessageService;
	@Autowired
	private EmqKeeper emqKeeper;
	@Autowired
	private RedisTemplate redisTemplate;

	@Autowired
	private TmCylinderOffloadingService cylinderOffloadingService;

	@Autowired
	private CylinderService cylinderService;

	private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶企业信息")
	@PostMapping(value = "/unit")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderUnit(@RequestBody List<TmCylinderUnitModel> unitData) {
		cylinderFillingDataValidationService.validateCylinderUnit(unitData);
		return ResponseHelper.buildResponse(cylinderUnitService.createCylinderUnit(unitData));
	}

	@Deprecated
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶基础数据")
	@PostMapping(value = "/info")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderInfo(@RequestBody List<TmCylinderInfoModel> infoData) {
		cylinderFillingDataValidationService.validateCylinderInfo(infoData);
		return ResponseHelper.buildResponse(cylinderInfoService.createCylinderInfo(infoData));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶标签数据")
	@PostMapping(value = "/tag")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderTagInfo(@RequestBody List<TmCylinderTagsModel> tagData) {
		cylinderFillingDataValidationService.validateCylinderTag(tagData);
		return ResponseHelper.buildResponse(cylinderTagsService.createCylinderTag(tagData));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶检验数据")
	@PostMapping(value = "/inspection")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderInspectionInfo(@RequestBody List<TmCylinderInspectionModel> inspectionData) {
		cylinderFillingDataValidationService.validateCylinderInspection(inspectionData);
		return ResponseHelper.buildResponse(cylinderInspectionService.createCylinderInspection(inspectionData));

	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶充装数据")
	@PostMapping(value = "/filling")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderFillingInfo(@RequestBody String fillingData) throws Exception {
		cylinderService.cylinderFillingHandler(fillingData);
		return ResponseHelper.buildResponse("OK");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶充装审核数据")
	@PostMapping(value = "/fillingAudit")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderFillingAudit(@RequestBody List<TmCylinderFillingExamineModel> fillingAuditData) {
		cylinderFillingDataValidationService.validateCylinderFillingExamineModel(fillingAuditData);
		return ResponseHelper.buildResponse(cylinderFillingExamineService.createCylinderFillingExamine(fillingAuditData));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气站卸液量记录数据")
	@PostMapping(value = "/offloading")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> createCylinderOffloading(@RequestBody List<TmCylinderOffloadingModel> offloadingData) {
		cylinderFillingDataValidationService.validateCylinderOffloadingData(offloadingData);
		return ResponseHelper.buildResponse(cylinderOffloadingService.createCylinderOffloading(offloadingData));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶是否合规校验")
	@PostMapping(value = "/complianceCheck")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<Object> complianceCheck(@RequestBody Map<String, List<String>> sequenceCodes) {
		return ResponseHelper.buildResponse(cylinderInfoService.complianceCheck(sequenceCodes));
	}
}
