package com.yeejoin.amos.boot.module.ys.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ys.api.dto.YsEmergencyPlanDto;
import com.yeejoin.amos.boot.module.ys.api.service.IYsEmergencyPlanService;
import com.yeejoin.amos.boot.module.ys.biz.service.impl.YsEmergencyPlanServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 *
 * @author system_generator
 * @date 2024-09-24
 */
@RestController
@Api(tags = "应急预案管理")
@RequestMapping(value = "/ys-emergency-plan")
public class YsEmergencyPlanController extends BaseController {

	@Autowired
	IYsEmergencyPlanService iYsEmergencyPlanService;

    @Autowired
    YsEmergencyPlanServiceImpl ysEmergencyPlanServiceImpl;

    /**
     * 新增或者更新接口
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveOrUpdate")
	@ApiOperation(httpMethod = "POST", value = "新增或者更新接口", notes = "新增或者更新接口")
	public ResponseModel<Boolean> saveOrUpdate(@RequestBody YsEmergencyPlanDto model) {
		AgencyUserModel userModel = getSelectedOrgInfo().getUserModel();
		return ResponseHelper.buildResponse(iYsEmergencyPlanService.saveOrUpdate(model,userModel));
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<YsEmergencyPlanDto> updateBySequenceNbrYsEmergencyPlan(@RequestBody YsEmergencyPlanDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(ysEmergencyPlanServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/deleteBySeq")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySeq(@RequestParam (value = "sequenceNbr") String sequenceNbr){
        return ResponseHelper.buildResponse(iYsEmergencyPlanService.deleteBySeq(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/detailBySeq")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<YsEmergencyPlanDto> detailBySeq(@RequestParam(value = "sequenceNbr") String  sequenceNbr) {
	    return ResponseHelper.buildResponse(iYsEmergencyPlanService.detailBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<YsEmergencyPlanDto>> queryForPage(@RequestParam(value = "current") int current,
																@RequestParam(value = "size") int size,
																YsEmergencyPlanDto dto) {
	    Page<YsEmergencyPlanDto> page = new Page<YsEmergencyPlanDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(iYsEmergencyPlanService.queryForYsEmergencyPlanPage(page,dto));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<YsEmergencyPlanDto>> selectForList() {
	    return ResponseHelper.buildResponse(ysEmergencyPlanServiceImpl.queryForYsEmergencyPlanList());
	}
}
