package com.yeejoin.amos.boot.module.jg.biz.edit.utils;

import java.lang.reflect.Field;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectiveFieldAccessor {

    private static final Map<Class<?>, List<Field>> fieldCache = new ConcurrentHashMap<>();


    public static List<Field> getAllFields(Class<?> clazz) {
        return fieldCache.computeIfAbsent(clazz, k -> {
            Class<?> clazz1 = clazz;
            List<Field> fields = new ArrayList<>();
            while (clazz1 != null && clazz1 != Object.class) {
                fields.addAll(Arrays.asList(clazz1.getDeclaredFields()));
                clazz1 = clazz1.getSuperclass(); // 递归向上获取父类
            }
            return Collections.unmodifiableList(fields);
        });
    }
}
