package com.yeejoin.amos.boot.module.jg.biz.refresh.handler;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.common.api.dao.EsEquipmentDao;
import com.yeejoin.amos.boot.module.common.api.entity.ESEquipmentInfo;
import com.yeejoin.amos.boot.module.common.api.entity.TzsDataRefreshMessage;
import com.yeejoin.amos.boot.module.common.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.common.api.service.IDataRefreshHandler;
import com.yeejoin.amos.boot.module.common.biz.refresh.DataRefreshEvent;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationManage;
import com.yeejoin.amos.boot.module.jg.biz.refresh.StatisticsDataUpdateService;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgInspectionDetectionInfoService;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgMaintenanceRecordInfoServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgUseInfoServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgUseRegistrationManageServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgInspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgMaintenanceRecordInfo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.*;
import java.util.stream.Collectors;

@Component
@RequiredArgsConstructor
@Slf4j
public class EquipmentRefreshHandler implements IDataRefreshHandler {

    private final IdxBizJgUseInfoServiceImpl useInfoService;
    private final IIdxBizJgInspectionDetectionInfoService iIdxBizJgInspectionDetectionInfoService;
    private final EsEquipmentDao esEquipmentDao;
    private final IdxBizJgMaintenanceRecordInfoServiceImpl maintenanceRecordInfoService;
    private final StatisticsDataUpdateService statisticsDataUpdateService;
    private final JgUseRegistrationManageServiceImpl jgUseRegistrationManageServiceImpl;


    @Override
    public String supportType() {
        return "equipment";
    }

    @Override
    public void doRefresh(TzsDataRefreshMessage message) {
        log.info("三库数据，设备开始刷库：唯一标识：{}", message.getDataId());
        switch (DataRefreshEvent.Operation.valueOf(message.getOperation())) {
            case DELETE:
                esEquipmentDao.deleteById(message.getDataId());
                break;
            case INSERT:
            case UPDATE:
                String record = message.getDataId();
                ESEquipmentInfo esEquipmentInfo = new ESEquipmentInfo();
                Map<String, Object> detail = useInfoService.getBaseMapper().queryDetail(record);
                if(detail == null) {
                    return;
                }
                StatisticsDataUpdateService.formatUseDate(detail);
                BeanUtil.copyProperties(detail, esEquipmentInfo, true);
                List<IdxBizJgInspectionDetectionInfo> inspectionDetectionInfos = iIdxBizJgInspectionDetectionInfoService.queryLastedGroupByInspectType(record);
                IdxBizJgInspectionDetectionInfo inspectionDetectionInfo = iIdxBizJgInspectionDetectionInfoService.queryNewestDetailByRecord(record);
                IdxBizJgMaintenanceRecordInfo lastMaintenanceRecordInfo = maintenanceRecordInfoService.queryNewestDetailByRecord(record);
                StatisticsDataUpdateService.formatInspectDate(esEquipmentInfo, inspectionDetectionInfo, record);
                esEquipmentInfo.setIssueDate(getIssueDate(esEquipmentInfo.getUSE_ORG_CODE()));
                esEquipmentInfo.setMAINTAIN_UNIT(lastMaintenanceRecordInfo.getMeUnitCreditCode());
                esEquipmentInfo.setMAINTAIN_UNIT_NAME(lastMaintenanceRecordInfo.getMeUnitName());
                esEquipmentInfo.setInspections(BeanUtil.copyToList(inspectionDetectionInfos, ESEquipmentInfo.Inspection.class));
                esEquipmentInfo.setMaintenances(lastMaintenanceRecordInfo.getSequenceNbr() != null ? Collections.singletonList(BeanUtil.copyProperties(lastMaintenanceRecordInfo, ESEquipmentInfo.Maintenance.class)) : new ArrayList<>());
                esEquipmentInfo.setTechParams(this.buildTechParamByEquList(record, esEquipmentInfo.getEQU_LIST_CODE()));
                if (EquipmentClassifityEnum.YLGD.getCode().equals(esEquipmentInfo.getEQU_LIST_CODE())) {
                    List<ESEquipmentInfo.TechParam> techParams = esEquipmentInfo.getTechParams();
                    List<ESEquipmentInfo.TechParam> pipeLength = techParams.stream().filter(e -> e.getParamKey().equals("pipeLength") && e.getDoubleValue() != null).collect(Collectors.toList());
                    if (!ObjectUtils.isEmpty(pipeLength)) {
                        esEquipmentInfo.setPipeLength(pipeLength.get(0).getDoubleValue());
                    }
                }
                esEquipmentDao.save(esEquipmentInfo);
                break;
            default:
                log.error("unknown operation: {}", message.getOperation());
        }
    }


    private List<ESEquipmentInfo.TechParam> buildTechParamByEquList(String record, String equListCode) {
        return StringUtils.isNotEmpty(equListCode) ? statisticsDataUpdateService.getTechParams(equListCode, record) : new ArrayList<>();
    }

    private LocalDate getIssueDate(String useRegistrationCode) {
        if (StringUtils.isEmpty(useRegistrationCode)) {
            return null;
        }
        LambdaQueryWrapper<JgUseRegistrationManage> useRegistrationManageWrapper = new LambdaQueryWrapper<>();
        useRegistrationManageWrapper.eq(JgUseRegistrationManage::getUseRegistrationCode, useRegistrationCode)
                .isNotNull(JgUseRegistrationManage::getUseRegistrationCode)
                .eq(JgUseRegistrationManage::getCertificateStatus, "已登记")
                .eq(BaseEntity::getIsDelete, false).select(BaseEntity::getSequenceNbr, JgUseRegistrationManage::getRegDate);
        JgUseRegistrationManage manage = jgUseRegistrationManageServiceImpl.getBaseMapper().selectOne(useRegistrationManageWrapper);
        return Optional.ofNullable(manage).map(JgUseRegistrationManage::getRegDate).map(d -> d.toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).orElse(null);
    }
}
