package com.yeejoin.amos.boot.module.jyjc.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationModel;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.InspectionChargePersonServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzsUserInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsUserInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 检验负责人控制期
 *
 * @author Administrator
 */
@RestController
@RequestMapping(value = "/inspect-charge/person")
@Api(tags = " 业务负责人")
@RequiredArgsConstructor
public class InspectionChargePersonController extends BaseController {

    private final InspectionChargePersonServiceImpl chargePersonService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/{applicationSeq}/save")
    @ApiOperation(httpMethod = "GET", value = "业务负责人安排保存", notes = "业务负责人安排保存")
    public ResponseModel<JyjcInspectionApplicationModel> savePlanData(@PathVariable String applicationSeq,
                                                                      @RequestBody JyjcInspectionApplicationModel model) {
        return ResponseHelper.buildResponse(chargePersonService.saveChargePersonData(applicationSeq, model));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/user/list")
    @ApiOperation(httpMethod = "GET", value = "业务负责人查询", notes = "业务负责人查询")
    public ResponseModel<List<TzsUserInfo>> getUserList() {
        return ResponseHelper.buildResponse(chargePersonService.getUserList(getSelectedOrgInfo().getCompany()));
    }
}
