package com.yeejoin.amos.patrol.business.util;

import com.yeejoin.amos.patrol.business.param.RoutePageParam;
import com.yeejoin.amos.patrol.core.common.request.CommonPageable;
import com.yeejoin.amos.patrol.core.common.request.CommonRequest;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;
import java.util.List;

public class RoutePageParamUtil {

	public static RoutePageParam fillRouteInfoParam(List<CommonRequest> queryRequests, CommonPageable commonPageable,
			HashMap<String, Object> orgCodeMap) {
		RoutePageParam param = new RoutePageParam();
		for (int i = 0; i < queryRequests.size(); i++) {
			String name = queryRequests.get(i).getName();
			if ("name".equals(name)) {
				param.setName(toString(queryRequests.get(i).getValue()));
			} else if ("remark".equals(name)) {
				param.setRemark(toString(queryRequests.get(i).getValue()));
			} else if ("deptId".equals(name)) {
				if (!ObjectUtils.isEmpty(queryRequests.get(i).getValue())) {
					param.setDeptId(Long.valueOf(toString(queryRequests.get(i).getValue())));
				}
			}
		}

		param.setOrgCode(orgCodeMap.get("orgCode") == null ? null:orgCodeMap.get("orgCode").toString());
		if (param.getDeptId() == null) {
			param.setDeptId(orgCodeMap.get("deptId") == null ? null:Long.valueOf(orgCodeMap.get("deptId").toString()));

		}
		if (commonPageable != null) {
			param.setPageNumber(commonPageable.getPageNumber());
			param.setPageSize(commonPageable.getPageSize());
		}
		return param;
	}

	private static String toString(Object value) {
		if (null == value || value == "") {
			return null;
		} else {
			return value.toString();
		}
	}
	
	public static HashMap<String, Object> fillRouteInfo(List<CommonRequest> queryRequests, HashMap<String, Object> param) {
//		HashMap<String, Object> param = new HashMap<String, Object>();
		if (ObjectUtils.isEmpty(queryRequests)) {
			return param;
		}
		for (CommonRequest request : queryRequests) {
			if (!ObjectUtils.isEmpty(request) && !ObjectUtils.isEmpty(request.getName())) {
				param.put(request.getName(), request.getValue());
			}
		}
		return param;
	}
}
