package com.yeejoin.amos.api.openapi.face.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
* 特种设备基本信息-设计信息Vo
*
* @author duanwei
* @date 2022-07-20
*/
@EqualsAndHashCode(callSuper = true)
@Data
public class DesignInfoModel extends AbstractBaseModel {


    private List designFile;
    private List designCode;

    private static final long serialVersionUID = 1L;

            @ApiModelProperty(value = "设备唯一标识码")
    /**
    * 设备唯一标识码
    */
    private String sequenceCode;
            @ApiModelProperty(value = "监管系统唯一编码(监管系统对接标识)")
    /**
    * 监管系统唯一编码(监管系统对接标识)
    */
    private String superviseCode;
            @ApiModelProperty(value = "设计单位统一社会信用代码")
    /**
    * 设计单位统一社会信用代码
    */
    private String designUnitCreditCode;
            @ApiModelProperty(value = "设计单位名称")
    /**
    * 设计单位名称
    */
    private String designUnitName;
            @ApiModelProperty(value = "设计许可编号")
    /**
    * 设计许可编号
    */
    private String designLicenseNum;
            @ApiModelProperty(value = "设计使用年限")
    /**
    * 设计使用年限
    */
    private Integer designUseDate;
            @ApiModelProperty(value = "设计日期")
    /**
    * 设计日期
    */
    private Date designDate;
            @ApiModelProperty(value = "总图图号")
    /**
    * 总图图号
    */
    private String drawingDo;
            @ApiModelProperty(value = "设计文件鉴定单位")
    /**
    * 设计文件鉴定单位
    */
    private String appraisalUnit;
            @ApiModelProperty(value = "设计文件鉴定日期")
    /**
    * 设计文件鉴定日期
    */
    private Date appraisalDate;


}
