package com.yeejoin.amos.boot.module.ccs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 设备报警信息表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FireEquipmentSignalDto", description = "设备报警信息表")
public class FireEquipmentSignalDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "站点名称")
    private String stationName;

    @ApiModelProperty(value = "站点编码")
    private String stationCode;

    private String fireEquipmentName;

    @ApiModelProperty(value = "消防设备id")
    private String fireEquipmentMrid;

    @ApiModelProperty(value = "设备编码")
    private String iotCode;

    @ApiModelProperty(value = "指标名称")
    private String fireEquipmentIndexName;

    @ApiModelProperty(value = "指标编码")
    private String fireEquipmentIndexKey;

    @ApiModelProperty(value = "报警值")
    private String fireEquipmentIndexValue;

    @ApiModelProperty(value = "发生频次")
    private Integer frequency;

    @ApiModelProperty(value = "报警状态：1报警0恢复")
    private Boolean status;

    @ApiModelProperty(value = "报警类型:alarm_type_fire（火灾报警）/alarm_type_trouble（故障告警）")
    private String type;


    @ApiModelProperty(value = "更新时间")
    private Date updateDate;

    @ApiModelProperty(value = "告警恢复时间")
    private Date recoveryDate;

    @ApiModelProperty(value = "装备所属消防系统code")
    private String systemMrids;

    @ApiModelProperty(value = "装备定义code（冗余字段）")
    private String equipmentDefinitionMrid;

    @ApiModelProperty(value = "装备定义名称")
    private String equipmentDefinitionName;

    @ApiModelProperty(value = "设备位置")
    private String location;

    @ApiModelProperty(value = "经度")
    private String lng;

    @ApiModelProperty(value = "纬度")
    private String lat;

}
