package com.yeejoin.equipmanage.common.datasync.entity.publics;

import com.alibaba.fastjson.JSON;
import com.yeejoin.equipmanage.common.datasync.enums.SyncDataOperationEnum;
import com.yeejoin.equipmanage.common.datasync.enums.SyncDataTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;

/**
 * <h1>同步消息实体</h1>
 *
 * @Author SingleTian
 * @Date 2021-04-01 09:19
 */
@Data
public class SyncDataMessage implements Serializable {

    private static final long serialVersionUID = 3950066933125606745L;

    /** 唯一ID */
    private String uid;

    /** 同步的数据类型 */
    private SyncDataTypeEnum type;

    /** 同步动作-增删改 */
    private SyncDataOperationEnum operation;

    /** 发生时间 */
    private Long timestamp;

    /**
     * 同步数据列表
     */
    private List<Serializable> data;

    /**
     * 获取对应的redis消息key
     * @return
     */
    public String redisKey(){
        assert type != null;
        return String.join("_", type.toString(), operation.toString(), uid);
    }

    /**
     * Message对象转换成字节码
     * @return
     */
    public byte[] message2Bytes(){
        return JSON.toJSONString(this).getBytes(StandardCharsets.UTF_8);
    }

    /**
     * 字节码转换成Message对象
     * @param messageBytes 字节码
     * @return
     */
    public static SyncDataMessage bytes2Message(byte[] messageBytes) {
        return JSON.parseObject(new String(messageBytes, StandardCharsets.UTF_8), SyncDataMessage.class);
    }
}
