package com.yeejoin.equipmanage.common.dto;

import java.util.List;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.common.dto
 * @ClassName: MenuFromDto
 * @Author: Jianqiang Gao
 * @Description: MenuFromDto
 * @Date: 2021/7/20 14:37
 * @Version: 1.0
 */
public class MenuFromDto {
    public String id;
    public String key;
    public String value;
    public String title;
    public String label;
    public String name;
    public String parentId;
    public Boolean isLeaf = true;
    public List<MenuFromDto> children;

    /**
     * 节点类型
     */
    public String nodeType;

    public MenuFromDto(String id, String value, String key, String title, String label, String name, String parentId,
                       String nodeType) {
        super();
        this.id = id;
        this.value = value;
        this.key = key;
        this.title = title;
        this.label = label;
        this.name = name;
        this.parentId = parentId;
        this.nodeType = nodeType;
    }

    public MenuFromDto(String key, String name, String parentId, String nodeType) {
        super();
        this.id = key;
        this.value = key;
        this.key = key;
        this.title = name;
        this.label = name;
        this.name = name;
        this.parentId = parentId;
        this.nodeType = nodeType;
    }

    public MenuFromDto() {
        super();
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Boolean getIsLeaf() {
        return isLeaf;
    }

    public void setIsLeaf(Boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public List<MenuFromDto> getChildren() {
        return children;
    }

    public void setChildren(List<MenuFromDto> children) {
        this.children = children;
    }

    public String getNodeType() {
        return nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }
}