package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_equipment_qrcode")
@ApiModel(value = "EquipmentQrcode对象", description = "")
public class EquipmentQrcode extends BaseEntity {

	private static final long serialVersionUID = 1L;

	private Long equipmentDetailId;

	private String qRCode;

	/**
	 * 单件并已被使用,默认false; 当入库成功后判断二维码所对应的装备符合当前条件时,设为true
	 */
	private boolean isSingleUsed = false;

	private Long carId;

	private Date productDate;

	@TableField(exist = false)
	private Date updateDate;

	@TableField(exist = false)
	private Date createDate;

	@TableField(exist = false)
	private String status;

	@TableField(exist = false)
	private String location;

	@TableField(exist = false)
	private String fullQRCode;

	public Boolean getIsSingleUsed() {
		return isSingleUsed;
	}

	public void setIsSingleUsed(Boolean isSingleUsed) {
		this.isSingleUsed = isSingleUsed;
	}

}
