package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author ZeHua Li
 * @date 2020/11/23 15:33
 * @since v2.0
 */
@Data
@TableName("wl_video_equipment_specific")
@ApiModel(value = "VideoEquipmentSpecific对象", description = "视频设备关联")
public class VideoEquipmentSpecific {

    @ApiModelProperty(value = "id")
    @TableId(type = IdType.ID_WORKER)
    private Long id;

    @ApiModelProperty(value = "视频id")
    @TableField(value = "video_id")
    private Long videoId;

    @ApiModelProperty(value = "设备id")
    @TableField(value = "equipment_specific_id")
    private Long equipmentSpecificId;

    @TableField(exist = false)
    private Date createDate;

}
