package com.yeejoin.equipmanage.common.entity.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.common.entity.dto
 * @ClassName: CarDto
 * @Author: Jianqiang Gao
 * @Description: CarDto
 * @Date: 2021/7/28 10:44
 * @Version: 1.0
 */
@Data
public class CarDto {

    @ApiModelProperty(value = "ID")
    private Long sequenceNbr;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "车牌号")
    private String carNum;

    @ApiModelProperty(value = "车辆状态")
    private String carState;

    @ApiModelProperty(value = "所属队伍id(来源于平台)")
    private Long teamId;

    @ApiModelProperty(value = "队伍名称(冗余字段来源于平台)")
    private String teamName;

    @ApiModelProperty(value = "随车人数（目前默认 4）")
    private Integer personNum;

    @ApiModelProperty(value = "距离")
    private Double distance;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "物联编码")
    private String iotCode;
}