package com.yeejoin.equipmanage.common.entity.vo;

import com.yeejoin.equipmanage.common.entity.*;
import com.yeejoin.equipmanage.common.vo.BuildingTreeVo;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author ZeHua Li
 * @date 2021/1/22 13:52
 * @since v2.0
 * app离线下载全部数据
 */
@Data
public class AppDownloadVO {

    /**
     * 装备
     */
    private List<DownloadEquipmentDataVO> downloadEquipmentDatas = new ArrayList<>();

    /**
     * 车辆
     */
    private List<Car> downloadCarDatas = new ArrayList<>();

    /**
     * 建筑
     */
    private List<BuildingTreeVo> buildTree = new ArrayList<>();

    /**
     *设备对应性能指标
     */
    private List<EquipmentSpecificIndex> equipmentSpecificIndexs = new ArrayList<>();

    /**
     *性能指标模板
     */
    private List<EquipmentIndex> equipmentIndex = new ArrayList<>();

    /**
     *货位
     */
    private List<WarehouseStructure> warehouseStructure = new ArrayList<>();

    /**
     * 车载装备
     */
    private List<EquipmentOnCar> equipmentOnCar = new ArrayList<>();

    /**
     * 车载灭火药剂
     */
    private List<ExtinguishantOnCar> extinguishantOnCar = new ArrayList<>();


    /**
     *报废原因
     */
    private List<SystemDic> reason = new ArrayList<>();

}
