package com.yeejoin.equipmanage.common.entity.vo;

import lombok.Data;

/**
 * @author ZeHua Li
 * @date 2021/1/22 10:27
 * @since v2.0
 * app离线模式数据下载实体
 */
@Data
public class DownloadEquipmentDataVO {

    /**
     * 单个设备id
     */
    private Long equipmentSpecificId;

    /**
     * 设备模板id
     */
    private Long equipmentSpecificEquipmentDetailId;

    /**
     *设备二维码
     */
    private String equipmentSpecificQrCode;

    /**
     * 管理方式(默认单件)
     */
    private Boolean equipmentSpecificSingle;

    /**
     * 设备编码
     */
    private String equipmentSpecificCode;

    /**
     * 设备模板名
     */
    private String equipmentDetailName;

    /**
     * 装备模板非核心性能指标
     */
    private String equipmentDetailPerfQuotaStr;

    /**
     * 装备定义id
     */
    private Long equipmentId;



    /**
     * 装备定义非核心性能指标
     */
    private String equipmentPrefQuota;

    /**
     * 库存数量
     */
    private Double stockDetailAmount;

    /**
     * 位置名
     */
    private String warehouseStructureName;

    /**
     * 位置描述
     */
    private String description;

    /**
     * 货位id
     */
    private Long stockDetailWarehouseStructureId;

    /**
     * 仓库id
     */
    private Long stockDetailWarehouseId;

    /**
     * 库存状态
     */
    private String stockDetailStatus;

    /**
     * 库存详情id
     */
    private Long stockDetailId;

    /**
     * 数量单位id
     */
    private Long unitId;

    /**
     * 数量单位名称
     */
    private String unitName;

    /**
     * 装备定义code
     */
    private String categoryCode;

}
