package com.yeejoin.equipmanage.common.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.equipmanage.common.entity.vo.BuildingVideoListVO;
import com.yeejoin.equipmanage.common.entity.vo.BuildingVideoVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 建筑树
 * @author DELL
 */
@Data
@ApiModel("消防建筑树")
public class BuildingTreeVo {

    @ApiModelProperty("组态使用同步树使用id主键")
    private Long id;

    @ApiModelProperty("组态使用同步树使用节点名称")
    private String name;

    @ApiModelProperty("id主键")
    private Long instanceId;

    @ApiModelProperty("节点名称")
    private String instanceName;

    @ApiModelProperty("分组编号")
    private String groupCode;

    @ApiModelProperty("分组类型")
    private String groupType;

    @ApiModelProperty("父级id")
    private String parentId;

    @ApiModelProperty("风险层级")
    private String isRisk;

    @ApiModelProperty("画布id")
    private Long sceneId;

    @ApiModelProperty("统计")
    private Long total = 0L;

    @ApiModelProperty("获取建筑详情接口地址")
    private String detailPaneApi;


    @ApiModelProperty("获取建筑详情接口地址")
    private String apiUrl;


    @ApiModelProperty("children")
    private List<BuildingTreeVo> children;


    @ApiModelProperty("组态获取分页接口地址")
    @TableField(exist = false)
    private String detailListPaneApi;

    @ApiModelProperty("建筑绝对位置")
    @TableField(exist = false)
    private String absolutePosition;

    @ApiModelProperty("建筑地址")
    private String address;

    @ApiModelProperty("机构编码")
    private String bizOrgCode;

    @ApiModelProperty("机构名称")
    private String bizOrgName;

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("视频合集")
    private List<BuildingVideoVO> videoList;
}
