package com.yeejoin.equipmanage.common.vo;

import java.util.ArrayList;
import java.util.List;



/**
 * <pre>
 * 装备分类，向前端转换类
 * </pre>
 *
 */
public class StoreEquipmentClassificationResponse {
	
	private String equipmentClassificationId;    //分类id
	private String key;                          //key
	private String equipmentClassificationCode;  //分类编码
	private String equipmentClassificationName;  //分类名称
	private boolean isConsumeEquipment;          //是否是消耗装备
	private String remark;                       //备注
	private Long parentId;						 //父节点Id
	private String level;						 //级别
	private boolean hasLowerClassification;      //是否有下级分类
	private List<StoreEquipmentClassificationResponse> children = new ArrayList<>(); //下级分类
	
	private String label;                        //名称
	private String value;                        //值
	
	public Long getParentId() {
		return parentId;
	}
	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}
	public String getEquipmentClassificationCode() {
		return equipmentClassificationCode;
	}
	public void setEquipmentClassificationCode(String equipmentClassificationCode) {
		this.equipmentClassificationCode = equipmentClassificationCode;
	}
	public String getEquipmentClassificationName() {
		return equipmentClassificationName;
	}
	public void setEquipmentClassificationName(String equipmentClassificationName) {
		this.equipmentClassificationName = equipmentClassificationName;
	}
	public boolean isConsumeEquipment() {
		return isConsumeEquipment;
	}
	public void setConsumeEquipment(boolean isConsumeEquipment) {
		this.isConsumeEquipment = isConsumeEquipment;
	}
	public String getRemark() {
		return remark;
	}
	public void setRemark(String remark) {
		this.remark = remark;
	}
	public boolean isHasLowerClassification() {
		return hasLowerClassification;
	}
	public void setHasLowerClassification(boolean hasLowerClassification) {
		this.hasLowerClassification = hasLowerClassification;
	}
	public String getEquipmentClassificationId() {
		return equipmentClassificationId;
	}
	public void setEquipmentClassificationId(String equipmentClassificationId) {
		this.equipmentClassificationId = equipmentClassificationId;
		setKey(equipmentClassificationId);
	}
	public List<StoreEquipmentClassificationResponse> getChildren() {
		return children;
	}
	public void setChildren(List<StoreEquipmentClassificationResponse> children) {
		this.children = children;
	}
	public String getKey() {
		return key;
	}
	public void setKey(String key) {
		this.key = key;
	}
	public String getLabel() {
		return label;
	}
	public void setLabel(String label) {
		this.label = label;
	}
	public String getValue() {
		return value;
	}
	public void setValue(String value) {
		this.value = value;
	}
	public String getLevel() {
		return level;
	}
	public void setLevel(String level) {
		this.level = level;
	}
	
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((equipmentClassificationId == null) ? 0 : equipmentClassificationId.hashCode());
		result = prime * result + ((equipmentClassificationCode == null) ? 0 : equipmentClassificationCode.hashCode());
		result = prime * result + ((equipmentClassificationName == null) ? 0 : equipmentClassificationName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		 if (this == obj){
             return true;}
         if (obj == null){
             return false;}
         if (!(obj instanceof StoreEquipmentClassificationResponse)){
             return false;}
         StoreEquipmentClassificationResponse other = (StoreEquipmentClassificationResponse) obj;
         if (equipmentClassificationId == null)
         {
             if (other.equipmentClassificationId != null)
             {
                 return false;
             }
         }
         else if (!equipmentClassificationId.equals(other.equipmentClassificationId))
         {
             return false;
         }
         if (equipmentClassificationCode == null)
         {
             if (other.equipmentClassificationCode != null)
             {
                 return false;
             }
         }
         else if (!equipmentClassificationCode.equals(other.equipmentClassificationCode))
         {
             return false;
         }
         if (equipmentClassificationName == null)
         {
             if (other.equipmentClassificationName != null)
             {
                 return false;
             }
         }
         else if (!equipmentClassificationName.equals(other.equipmentClassificationName))
         {
             return false;
         }
         return true;
	}
	
}
