package com.yeejoin.amos.knowledgebase.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * <p>
 * 知识库系统动态选项配置，多用于动态字段配置
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("knowledge_dynamics_option")
public class KnowledgeDynamicsOption extends BaseEntity {


	/**
	 * 字段名
	 */
	@TableField("FIELD_NAME")
	private String fieldName;
	/**
	 * 中文名
	 */
	@TableField("FIELD_LABEL")
	private String fieldLabel;
	/**
	 * 数据类型：文本，数字，枚举,日期
	 */
	@TableField("DATA_TYPE")
	private String dataType;


	/**
	 * 功能标识
	 */
	@TableField("FUNCTIONAL")
	private String functional;

	/**
	 * 业务项目标识
	 */
	@TableField("APP_KEY")
	private String appKey;

	@TableField("FRONT_END_CONFIG")
	private String frontEndConfig;
	/**
	 * 机构编号
	 */
	@TableField("AGENCY_CODE")
	private String agencyCode;

	/**
	 * 分组主键
	 */
	@TableField("GROUP_SEQ")
	private Long  groupSeq;

	/**
	 * 查询策略
	 */
	@TableField("QUERY_STRATEGY")
	private String queryStrategy;
}

