package com.yeejoin.precontrol.common.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 作业活动Vo
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
public class TaskPageDto extends BaseDto {
	private static final long serialVersionUID = 1L;
	private Long id;
	/**
	 * 任务id集合
	 */
	@ApiModelProperty(value = "任务id集合", position = 99)
	private List<Long> ids;
	@ApiModelProperty(value = "作业类型")
	private Long type;
	@ApiModelProperty(value = "方案名称")
	private String name;
	@ApiModelProperty(value = "代号")
	private String code;
	@ApiModelProperty(value = "编号")
	private String number;
	@ApiModelProperty(value = "天气")
	private String weather;
	@ApiModelProperty(value = "发起人id")
	private Long createPersonId;
	@ApiModelProperty(value = "所属项目id")
	private Long projectId;
	@ApiModelProperty(value = "所属项目ids")
	private List<Long> projectIds;
	@ApiModelProperty(value = "项目名称")
	private String projectName;
	@ApiModelProperty(value = "任务状态")
	private List<Long> status;
	@ApiModelProperty(value = "超时状态")
	private Long currentStatus;
	@ApiModelProperty(value = "任务单号")
	private Long taskNo;

	@ApiModelProperty(value = "项目开始时间", position = 1)
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date startDate;
	@ApiModelProperty(value = "项目结束时间", position = 2)
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date endDate;
	@ApiModelProperty(value = "创建时间")
	private Date createDate;

	@ApiModelProperty(value = "App搜索条件")
	private String search;

	@ApiModelProperty(value = "任务开始时间", position = 3)
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date taskStartDate;
	@ApiModelProperty(value = "任务结束时间", position = 4)
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date taskEndDate;

	@ApiModelProperty(value = "是否风险作业")
	private String isRiskType;
	@ApiModelProperty(value = "预留参数,请勿传递")
	private Long userId;
	@ApiModelProperty(value = "预留参数,请勿传递")
	private Long companyId;
	
}
