package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.TableFormat;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 人员履历信息(打卡)
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_person_clock")
@ApiModel(value = "PersonClock对象", description = "人员履历信息(打卡)")
public class PersonClock extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "人员信息id")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "personName")
    private Long personId;
    @TableField(exist = false)
    private String personName;
    @ApiModelProperty(value = "出入场 0入场 1出场")
    private Integer inOrOut;
    @TableField(exist = false)
    private String inOrOutLabel;

    @ApiModelProperty(value = "打卡时间")
    private Date clockTime;
    @ApiModelProperty(value = "打卡项目id")
    private String clockProjectId;
    @ApiModelProperty(value = "打卡项目名称")
    private String clockProject;
    @ApiModelProperty(value = "打卡地名")
    private String clockAddress;

    @ApiModelProperty(value = "机构id")
    private String orgCode;
    @ApiModelProperty(value = "打卡公司id")
    private Long clockCompanyId;
    @ApiModelProperty(value = "打卡")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date clockDate;
    
    private String deviceNo;
}
