package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 项目入离岗打卡
 *
 * @author duanwei
 * @date 2020-07-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_project_clock")
@ApiModel(value = "ProjectClock对象", description = "项目入离岗打卡")
public class ProjectClock extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "人员信息id")
    private Long personId;

    @ApiModelProperty(value = "上岗 离岗")
    private Integer type;

    @ApiModelProperty(value = "打卡时间")
    private Date clockTime;

    @ApiModelProperty(value = "打卡项目")
    private String clockProject;

    @ApiModelProperty(value = "打卡项目id")
    private Long clockProjectId;

    @ApiModelProperty(value = "打卡地名")
    private String clockAddress;


}
