package com.yeejoin.precontrol.common.enums;

public enum ExchangeStatusEnum {

    /**
     * 未兑换
     */
    UNDONE(0, "未兑换"),
    /**
     * 已兑换
     */
    DONE(1, "已兑换");

    private int type;

    private String name;

    ExchangeStatusEnum(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public int getType() {
        return type;
    }
    
    public long getLongType() {
        return Long.valueOf(type);
    }

    public String getName() {
        return name;
    }

    public static String getNameByType(Long type) {
        String name = null;
        for (ExchangeStatusEnum enumOne : ExchangeStatusEnum.values()) {
            if (enumOne.getType() == type) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }
}
