package com.yeejoin.precontrol.common.enums;

/**
 * 通用状态枚举
 */
public enum StatusEnum {
    /*
     * 未完成
     */
    UNFINISHED("未完成", 0L),
    /*
     * 完成
     */
    SUCCESS("完成", 1L),
	
    /*
     * 反馈
     */
    FEEDBACK("完成", 2L);

    private String label;
    private Long value;

    StatusEnum(String label, Long value) {
        this.label = label;
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Long getValue() {
        return value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public static String getLabelByValue(String value) {
        String label = null;
        for (ContractTypeEum type : ContractTypeEum.values()) {
            if (type.getValue().equals(value)) {
                label = type.getLabel();
                break;
            }
        }
        return label;
    }
}
