package com.yeejoin.precontrol.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.dto.TaskSalaryConfirmDto;
import com.yeejoin.precontrol.common.entity.TaskSalaryConfirm;
import com.yeejoin.precontrol.common.param.PersonParam;
import com.yeejoin.precontrol.common.vo.PersonVo;
import com.yeejoin.precontrol.common.vo.TaskSalaryConfirmOneVo;
import com.yeejoin.precontrol.common.vo.TaskSalaryConfirmVo;

import java.util.List;

/**
 * 薪资确认任务表 Mapper 接口
 *
 * @author duanwei
 * @date 2020-12-08
 */
public interface TaskSalaryConfirmMapper extends BaseMapper<TaskSalaryConfirm> {

	IPage<TaskSalaryConfirmVo> pageInfo(Page<TaskSalaryConfirmVo> page, TaskSalaryConfirmDto taskSalaryConfirmDto);

	IPage<TaskSalaryConfirmOneVo> pageTodo(Page<TaskSalaryConfirmOneVo> page,
			TaskSalaryConfirmOneVo taskSalaryConfirmOneVo);

	TaskSalaryConfirmOneVo pageTodoDetail(long taskPersonId,long personId);

	IPage<PersonVo> persons(Page<PersonVo> page, long taskId, PersonParam param);

	Integer paidRatio(long projectId, long companyId);

	List<PersonVo> warnPersons(int day);
	
	int firstReadCount(long personId);
	
}
