package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.entity.PersonExaminationAttachment;
import com.yeejoin.precontrol.common.mapper.PersonExaminationAttachmentMapper;
import com.yeejoin.precontrol.common.service.IPersonExaminationAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 人员体检信息附件 服务实现类
 *
 * @author duanwei
 * @date 2020-06-30
 */
@Service
public class PersonExaminationAttachmentServiceImpl extends ServiceImpl<PersonExaminationAttachmentMapper, PersonExaminationAttachment> implements IPersonExaminationAttachmentService {
    @Autowired
    PersonExaminationAttachmentMapper examinatAttachMapper;
    @Value("${fileserver.domain}")
    String fileServerUrl;

    @Override
    public void saveAttach(Long id, List<PersonExaminationAttachment> attachment) {
        examinatAttachMapper.delete(new QueryWrapper<PersonExaminationAttachment>().eq("person_examination_id", id));
        if (attachment != null) {
            attachment.forEach(a -> {
                a.setPersonExaminationId(id);
                if (a.getAttachment() != null) {
                    a.setAttachment(a.getAttachment().replace(fileServerUrl, ""));
                }
                examinatAttachMapper.insert(a);
            });
        }
    }
}
