package com.yeejoin.precontrol.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import static com.yeejoin.precontrol.common.utils.DateUtils.getMonth;
import static com.yeejoin.precontrol.common.utils.DateUtils.getYear;

/**
 * @description:
 * @author: duanwei
 * @date: 2020-07-15 20:49
 **/
public class DateTools {
    /**
     * 日期转星期
     *
     * @return
     */
    public static String dateToWeek(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String format = sdf.format(date);
        String[] weekDays = {"星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"};
        Calendar cal = Calendar.getInstance(); // 获得一个日历
        Date datet;
        try {
            datet = sdf.parse(format);
            cal.setTime(datet);
        } catch (Exception e) {
            e.printStackTrace();
        }
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1; // 指示一个星期中的某天。
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }


    /**
     *      * 获取本月已过去的所有日期
     *      * @return
     */
    public static LinkedList<String> getMonthDays() {
        LinkedList<String> resultList = new LinkedList<>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String today = dateFormat.format(new Date());
        int days = Integer.parseInt(today.substring(8));
        String month = today.substring(0, 8);
        for (int i = 1; i <= days; i++) {
            String date;
            if (i < 10) {
                date = month + "0" + String.valueOf(i);
            } else {
                date = month + String.valueOf(i);
            }
            resultList.add(date);
        }
        return resultList;
    }


    /**
     * 判断传入日期是否是当月
     *
     * @param date
     * @return
     */
    public static boolean isThisTime(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String now = sdf.format(new Date());//当前时间
        if (date.equals(now)) {
            return true;
        }
        return false;
    }


    /**
     * java 获取 获取某年某月 所有日期（yyyy-mm-dd格式字符串）
     *
     * @param year
     * @param month
     * @return
     */
    public List<String> getMonthFullDay(int year, int month) {
        SimpleDateFormat dateFormatYyyyUuDd = new SimpleDateFormat("yyyy-MM-dd");
        List<String> fullDayList = new ArrayList<>(32);
        // 获得当前日期对象
        Calendar cal = Calendar.getInstance();
        cal.clear();// 清除信息
        cal.set(Calendar.YEAR, year);
        // 1月从0开始
        cal.set(Calendar.MONTH, month - 1);
        // 当月1号
        cal.set(Calendar.DAY_OF_MONTH, 1);
        int count = cal.getActualMaximum(Calendar.DAY_OF_MONTH);
        for (int j = 1; j <= count; j++) {
            fullDayList.add(dateFormatYyyyUuDd.format(cal.getTime()));
            cal.add(Calendar.DAY_OF_MONTH, 1);
        }
        return fullDayList;
    }

    /**
     * 获取某年某月每一天日期
     *
     * @return
     */
    public static LinkedList<String> getMonthEveryDays(Date date) {
        LinkedList<String> dates = new LinkedList<>();
        try {
            int year = getYear(date);
            int month = getMonth(date);
            Integer num = getDaysByYearMonth(year, month);
            String monthValue;
            String dayValue;
            if (month < 10) {
                monthValue = "0" + month;
            } else {
                monthValue = String.valueOf(month);
            }
            for (int i = 1; i <= num; i++) {
                if (i < 10) {
                    dayValue = "0" + i;
                } else {
                    dayValue = String.valueOf(i);
                }
                dates.add(year + "-" + monthValue + "-" + dayValue);
            }
            return dates;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    /**
     * 根据年 月 获取对应的月份 天数
     */
    public static int getDaysByYearMonth(int year, int month) {
        Calendar a = Calendar.getInstance();
        a.set(Calendar.YEAR, year);
        a.set(Calendar.MONTH, month - 1);
        a.set(Calendar.DATE, 1);
        a.roll(Calendar.DATE, -1);
        int maxDate = a.get(Calendar.DATE);
        return maxDate;
    }


    /**
     * 获取过去7天内的日期数组
     *
     * @param intervals intervals天内
     * @return 日期数组
     */
    public static ArrayList<String> getDays(int intervals) {
        ArrayList<String> pastDaysList = new ArrayList<>();
        for (int i = intervals - 1; i >= 0; i--) {
            pastDaysList.add(getPastDate(i));
        }
        return pastDaysList;
    }

    /**
     * 获取过去第几天的日期
     *
     * @param past
     * @return
     */
    public static String getPastDate(int past) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - past);
        Date today = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String result = format.format(today);
        return result;
    }

    /**
     * 计算两个时间之间的天数
     *
     * @param startDate
     * @param endDate
     * @return
     * @throws ParseException
     */
    public static int getDayDiffer(Date startDate, Date endDate) throws ParseException {
        //判断是否跨年
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
        String startYear = yearFormat.format(startDate);
        String endYear = yearFormat.format(endDate);
        if (startYear.equals(endYear)) {
            /*  使用Calendar跨年的情况会出现问题    */
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            int startDay = calendar.get(Calendar.DAY_OF_YEAR);
            calendar.setTime(endDate);
            int endDay = calendar.get(Calendar.DAY_OF_YEAR);
            return endDay - startDay;
        } else {
            /*  跨年不会出现问题，需要注意不满24小时情况（2016-03-18 11:59:59 和 2016-03-19 00:00:01的话差值为 0）  */
            //  只格式化日期，消除不满24小时影响
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            long startDateTime = dateFormat.parse(dateFormat.format(startDate)).getTime();
            long endDateTime = dateFormat.parse(dateFormat.format(endDate)).getTime();
            return (int) ((endDateTime - startDateTime) / (1000 * 3600 * 24));
        }
    }
}
