package com.yeejoin.precontrol.common.vo;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @description: 违规管理
 * @author: duanwei
 * @date: 2020-07-17 15:48
 **/
@Data
public class SingBadManagementVo {

    //人员类型 0主持人 1交底人 2施工负责人 3安全员 4记录人 5交底人员 6技术员 7工程人员 8施工人员 9违章人员 10分包商负责人 99 发布人
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "任务id")
    private Long id;
    @ApiModelProperty(value = "所属项目id")
    private Long projectId;
    @ApiModelProperty(value = "起止时间")
    private Date startTime;
    @ApiModelProperty(value = "结束时间")
    private Date endTime;
    @ApiModelProperty(value = "违规内容")
    private String badText;

    @ApiModelProperty(value = "文件路径")
    @ImagePrefix
    private List<String> filePath;

    @ApiModelProperty(value = "违规企业")
    private Long companyId;
    @ApiModelProperty(value = "分包商负责人")
    private Long personLiable;


}

