package com.yeejoin.amos.supervision.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the p_task_forward_log database table.
 * 
 */
@Entity
@Table(name="p_task_forward_log")
@NamedQuery(name="TaskForwardLog.findAll", query="SELECT t FROM TaskForwardLog t")
public class TaskForwardLog extends BasicEntity{
	private static final long serialVersionUID = 1L;

	private String content; // 任务转发详情

	@Column(name="created_by")
	private int createdBy; // 创建人

	private String executor; // 任务发转发执行人
	
	/**
	 * 转发后执行人id
	 */
	@Column(name="executor_id")
	private String executorId;

	@Column(name="task_id")
	private Long taskId; // 任务ID

	public TaskForwardLog() {
	}

	public String getContent() {
		return this.content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public int getCreatedBy() {
		return this.createdBy;
	}

	public void setCreatedBy(int createdBy) {
		this.createdBy = createdBy;
	}

	public String getExecutor() {
		return this.executor;
	}

	public void setExecutor(String executor) {
		this.executor = executor;
	}

	public String getExecutorId() {
		return executorId;
	}

	public void setExecutorId(String executorId) {
		this.executorId = executorId;
	}

	public Long getTaskId() {
		return this.taskId;
	}

	public void setTaskId(Long taskId) {
		this.taskId = taskId;
	}

}