package com.yeejoin.equipmanage.controller;

import com.alibaba.fastjson.JSONArray;
import com.yeejoin.equipmanage.service.impl.NrApiInvocationImpl;
import com.yeejoin.equipmanage.service.impl.SyncDataServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

@RestController
@Api(tags = "南瑞Api调用")
@RequestMapping(value = "/nrApi", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class NRApiInvocationController  {

    private final Logger logger = LoggerFactory.getLogger(NRApiInvocationController.class);
    @Autowired
    private SyncDataServiceImpl syncDataService;
    @Autowired
    private NrApiInvocationImpl invocation;

    @RequestMapping(value = "/getRealTimeData", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "get", value = "获取南瑞实时数据")
    public JSONArray getRealTimeData()  {
        try {

            JSONArray nrRealTime = invocation.getNrRealTime();
            logger.info("获取南瑞实时数据aaaaaaaaaa",nrRealTime);
            return nrRealTime;
        } catch (Exception e) {
            logger.info("获取南瑞实时数据",e);
            return new JSONArray();
        }

    }


}
