package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.entity.SignalClassify;
import com.yeejoin.equipmanage.service.ISignalClassifyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 信号分类量测枚举表
 *
 * @author system_generator
 * @date 2022-02-18
 */
@RestController
@Api(tags = "信号分类量测枚举表Api")
@RequestMapping(value = "/signal/classify", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class SignalClassifyController extends AbstractBaseController {

    @Autowired
	ISignalClassifyService iSignalClassifyService;

    /**
     * 新增信号分类量测枚举表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增信号分类量测枚举表", notes = "新增信号分类量测枚举表")
	public ResponseModel<SignalClassify> save(@RequestBody SignalClassify model) {
	    boolean bool = iSignalClassifyService.save(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据id更新
     *
     * @param id 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{id}")
	@ApiOperation(httpMethod = "PUT", value = "根据id更新信号分类量测枚举表", notes = "根据id更新信号分类量测枚举表")
	public ResponseModel<SignalClassify> updateByidWlSignalClassify(@RequestBody SignalClassify model, @PathVariable(value = "id") Long id) {
	    model.setId(id);
	    boolean bool = iSignalClassifyService.updateById(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据id删除
     *
     * @param id 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{id}")
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除信号分类量测枚举表", notes = "根据id删除信号分类量测枚举表")
    public ResponseModel<Boolean> deleteByid(HttpServletRequest request, @PathVariable(value = "id") Long id){
        return ResponseHelper.buildResponse(iSignalClassifyService.removeById(id));
    }

    /**
     * 根据id查询
     *
	 * @param id  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{id}")
	@ApiOperation(httpMethod = "GET",value = "根据id查询单个信号分类量测枚举表",  notes = "根据id查询单个信号分类量测枚举表")
	public ResponseModel<SignalClassify> selectOne(@PathVariable Long id) {
	    return ResponseHelper.buildResponse(iSignalClassifyService.getById(id));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "信号分类量测枚举表列表全部数据查询",   notes = "信号分类量测枚举表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<SignalClassify>> selectForList(@RequestParam(required = false) String isAlarm,
															 @RequestParam(required = false) String isContainFire) {


		if(!ValidationUtil.isEmpty(isAlarm) && "true".equals(isAlarm)) {
			if(!ValidationUtil.isEmpty(isContainFire) && "false".equals(isContainFire)) {
				return ResponseHelper.buildResponse(iSignalClassifyService.query().list().stream().filter(e->e.getIsAlarm() == 1 && !"FIREALARM".equals(e.getTypeCode())).collect(Collectors.toList()));
			} else {
				return ResponseHelper.buildResponse(iSignalClassifyService.query().list().stream().filter(e->e.getIsAlarm() == 1).collect(Collectors.toList()));
			}
		} else {
			return ResponseHelper.buildResponse(iSignalClassifyService.query().list());
		}
	}
}
