package com.yeejoin.equipmanage.remote;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.equipmanage.common.entity.vo.PersonVo;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * @author 人员服务
 */
@FeignClient(name= "${precontrol.feign.name}",configuration={MultipartSupportConfig.class, PrecontrolFeign.Configuration.class})
public interface PrecontrolFeign {

    /**
     * 人员信息
     * @return
     */
    @GetMapping("precontrol/person/list")
    FeignClientResult<Page<PersonVo>> peopleList();

    class Configuration {
        @Bean
        Encoder feignFormEncoder(ObjectFactory<HttpMessageConverters> converters) {
            return new SpringFormEncoder(new SpringEncoder(converters));
        }
    }
}
