package com.yeejoin.amos.fas.business.action;

import com.yeejoin.amos.fas.business.action.el.ELEvaluationContext;
import com.yeejoin.amos.fas.business.action.mq.WebMqttComponent;
import com.yeejoin.amos.fas.business.action.result.ActionResult;
import com.yeejoin.amos.fas.business.action.result.TipResult;
import com.yeejoin.amos.fas.business.action.result.message.AbstractActionResultMessage;
import com.yeejoin.amos.fas.business.action.util.DataItemUtil;
import com.yeejoin.amos.fas.business.service.intfc.IMessageService;
import com.yeejoin.amos.fas.business.service.model.ToipResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * <pre>
 * 消息提示动作
 * </pre>
 *
 * @author amos
 * @version $Id: SimpleTipAction.java, v 0.1 2019年4月24日 下午2:47:37 amos Exp $
 */
@Component
public class SimpleTipAction implements CustomerAction
{
	private static String PACKAGEURL = "com.yeejoin.amos.fas.business.action.result.message.";

	@Autowired
	private IMessageService messageService;

    @Autowired
    private WebMqttComponent webMqttComponent;

    @Value("${auto-sys.push.type}")
    private String pushType;
    @Value("${spring.application.name}")
    private String serviceName;


    @Value("${station.name}")
    private String stationName;

	//@ExposeAction("消息提示")
	public void sendMessageTip(Object bizobj, String title, String content, String type)
	{
		try
		{
			ELEvaluationContext.setVariable("bizobj",bizobj);
			TipResult result = new TipResult();
			result.add(bizobj);
			Map<String, Object> tempmap1 = new HashMap<>();
			tempmap1.put("title", title);
			result.add(tempmap1);
			Map<String, Object> tempmap2 = new HashMap<>();
			content =DataItemUtil.getNative(content);
			tempmap2.put("content", content);
			result.add(tempmap2);

			Constructor<?> constructor;

			constructor = Class.forName(
					PACKAGEURL + result.getClass().getSimpleName() + "Message")
					.getConstructor(ActionResult.class);
			 AbstractActionResultMessage<?> action = (AbstractActionResultMessage<?>) constructor.newInstance(result);
			String msgType = "message";
			if ("mqtt".equals(pushType.toLowerCase())) {
            	ToipResponse toipResponse = action.buildResponse(msgType, bizobj, result);
            	String topic = String.format("/%s/%s/%s", serviceName, stationName,"rule");
                webMqttComponent.publish(topic, toipResponse.toJsonStr());
            } else {
            	action.execute(msgType, bizobj);
            }
		}
		catch (Exception e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@Override
	public void intreeuptPlan(String batchNo) {

	}

//	@SuppressWarnings("unchecked")
//	private void saveMessageAction(AbstractActionResult abstractActionResult,String type)
//	{
//		Message message = new Message();
//		List<Map<String, Object>> list = (List<Map<String, Object>>) abstractActionResult.getData();
//		for(Map<String, Object> map : list) {
//			for(String str: map.keySet()) {
//				if(str.equals("content")) {
//					message.setContent(map.get("content").toString());
//				}else
//					if (str.equals("title"))
//					{
//						message.setTitle(map.get("title").toString());
//					}
//			}
//			if(!StringUtil.isNotEmpty(message.getContent())){
//				continue;
//			}
//			if (abstractActionResult.getToipResponse().getBizObj() instanceof MessageRo) {
//				MessageRo messageRo = (MessageRo)abstractActionResult.getToipResponse().getBizObj();
//				message.setTime(messageRo.getDateTime());
//				message.setBizId(messageRo.getId());
//			}
//			if (abstractActionResult.getToipResponse().getBizObj() instanceof RiskSourceRuleRo) {
//				RiskSourceRuleRo riskSourceRuleRo = (RiskSourceRuleRo) abstractActionResult.getToipResponse().getBizObj();
//				message.setTime(DateUtil.getNow());
//				message.setBizId(StringUtil.isNotEmpty(riskSourceRuleRo.getId()) ?
//				String.valueOf(riskSourceRuleRo.getId()) : "");
//			}
//			if (abstractActionResult.getToipResponse().getBizObj() instanceof ProtalDataRo) {
//				ProtalDataRo protalDataRo = (ProtalDataRo) abstractActionResult.getToipResponse().getBizObj();
//				message.setTime(DateUtil.getNow());
//				message.setBizId(StringUtil.isNotEmpty(protalDataRo.getId()) ? String.valueOf(protalDataRo.getId()) : "");
//			}
//			if (abstractActionResult.getToipResponse().getBizObj() instanceof FireEquimentDataRo) {
//				FireEquimentDataRo fireEquimentDataRo = (FireEquimentDataRo) abstractActionResult.getToipResponse().getBizObj();
//				message.setTime(DateUtil.getNow());
//				message.setBizId(StringUtil.isNotEmpty(fireEquimentDataRo.getId()) ? String.valueOf(fireEquimentDataRo.getId()) : "");
//			}
//			message.setBizclassName(abstractActionResult.getToipResponse().getBizObj().getClass().toString());
//			message.setType(type);
//			message.setId(UUID.randomUUID().toString());
//			messageService.save(message);
//		}
//	}
}
