package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.bo.FireInfoBo;
import com.yeejoin.amos.fas.business.bo.FireMoreDataBo;
import com.yeejoin.amos.fas.business.bo.FireParamBo;
import com.yeejoin.amos.fas.business.bo.FireRectificationBo;
import com.yeejoin.amos.fas.business.dao.mapper.FireRectificationMapper;
import com.yeejoin.amos.fas.business.service.intfc.FireRectificationService;
import com.yeejoin.amos.fas.business.util.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

@Service("fireRectificationService")
public class FireRectificationServiceImpl implements FireRectificationService {
    @Autowired
    FireRectificationMapper fireRectificationMapper;

    /**
     * 文件服务器地址
     */
    @Value("${file.url}")
    private  String ipUrl;

    /**
     * 根据条件查询对应单据
     * @param nameLike 单据模糊查询
     * @param sDate 起始日
     * @param eDate 终止日
     * @param states 状态
     * @param pageNum 页码
     * @param pageSize
     * @return
     */
    @Override
    public Map<String, Object> queryFiresAndCount(String nameLike, String sDate, String eDate, int states, int pageNum,int pageSize) {
        if(nameLike.trim().equals("")){
        nameLike = null;
        }
        Map<String, Object> map = new HashMap<>();
        int spage =  (pageNum-1)*pageSize;
        map.put("nameLike",nameLike);
        map.put("sDate",sDate);
        map.put("eDate",eDate);
        map.put("states",states);
        map.put("spage",spage);
        map.put("pageSize",pageSize);
        List<FireRectificationBo> fireRectificationBos = fireRectificationMapper.queryFiresAndCount(map);
        long countFires = fireRectificationMapper.countQueryFireList(map);
        map.clear();
        map.put("fireRectificationBos",fireRectificationBos);
        map.put("countFires",countFires);
        return map;
    }

    /**
     * 查询详细单据信息
     * @param billNo
     * @return
     */
    @Override
    public Map<String, Object> selectOneById(String billNo) {
        Map<String ,Object> result = new HashMap();
        FireRectificationBo base = fireRectificationMapper.selectOneForBase(billNo);
        List<FireMoreDataBo> warnnings = fireRectificationMapper.selectOneForEmergency(billNo);
        List<FireMoreDataBo> danger = fireRectificationMapper.selectOneForDanger(billNo);
        List<FireMoreDataBo> hidden = fireRectificationMapper.selectOneForHidden(billNo);
        List<FireInfoBo> files = new ArrayList<>();
        for (int i=0;i<4;i++){
            files.add(fireRectificationMapper.selectOneForfire(billNo,i));
        }
        Map<String ,Object> backResult = makeFIreString(files);
        result.put("base", base);
        result.put("warnnings", warnnings);
        result.put("danger", danger);
        result.put("hidden", hidden);
        result.put("fires", backResult.get("fires"));
        result.put("backResult", backResult.get("backResult"));
        return result;
    }

    /**
     * 下载文件
     * @param path
     * @param response
     */
    @Override
    public void downLoadFilesByUrll(String path, HttpServletResponse response) {
        List<String> list = Arrays.asList(path.split(","));
        try {
            FileUtils.downloadZIP(response,list,ipUrl);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 修改单据相关信息
     * @param paramBo
     * @return
     */
    @Override
    public Map<String, String> updateByid(FireParamBo paramBo) {
        Map<String, String> map = new HashMap<>();
        map.put("billNo",paramBo.getBillNo());
        map.put("backResult",paramBo.getBackResult());
        map.put("refResult",paramBo.getRefResult());
        try {
            if(isDataEmpty(paramBo.getBillNo(),null) ||
                    isDataEmpty(paramBo.getBackResult(),null) ||
                    isDataEmpty(paramBo.getRefResult(),null)
            ){
                fireRectificationMapper.updateBill(map);
            }
            if (isDataEmpty(null,paramBo.getWarnningData())){
                for (FireMoreDataBo bo : paramBo.getWarnningData()) {
                    fireRectificationMapper.updateWarnning(bo);
                }
            }
            if (isDataEmpty(null,paramBo.getHiddenData())){
                for (FireMoreDataBo bo : paramBo.getHiddenData()) {
                    fireRectificationMapper.updateHidden(bo);
                }
            }
            if (isDataEmpty(null,paramBo.getDangerData())){
                for (FireMoreDataBo bo : paramBo.getDangerData()) {
                    fireRectificationMapper.updateDanger(bo);
                }
            }
            map.clear();
        }catch (Exception e) {
            map.put("result","数据保存失败");
            map.put("message","error");
            return map;
        }
        map.put("result","数据保存成功");
        map.put("message","success");
        return map;
    }

    /**
     * 判空
     * @param data
     * @param list
     * @return
     */
    public boolean isDataEmpty (String data,List<FireMoreDataBo> list) {
        if (data != null){
            return  !("").equals(data);
        }
        return list != null && list.size() != 0;
    }

    /**
     * 生成返回拼接评价
     * @param files
     * @return
     */
    public    Map<String ,Object> makeFIreString(  List<FireInfoBo> files){
        Map<String ,Object> result = new HashMap();
        Map<String ,Object> newfires = new HashMap();

        String backResult = "，需加强";

        FireInfoBo fire1= files.get(0);
        FireInfoBo fire2= files.get(1);
        FireInfoBo fire3= files.get(2);
        FireInfoBo fire4= files.get(3);
        if (fire1 == null){
            fire1 = new FireInfoBo(0,0);
        }
        if (fire2 == null){
            fire2 = new FireInfoBo(0,0);
        }
        if (fire3 == null){
            fire3 = new FireInfoBo(0,0);
        }
        if (fire4 == null){
            fire4 = new FireInfoBo(0,0);
        }
        newfires.put("fire1rel",fire1.getRealNum());
        newfires.put("fire1thr",fire1.getThreshold());

        newfires.put("fire2rel",fire2.getRealNum());
        newfires.put("fire2thr",fire2.getThreshold());

        newfires.put("fire3rel",fire3.getRealNum());
        newfires.put("fire3thr",fire3.getThreshold());

        newfires.put("fire4rel",fire4.getRealNum());
        newfires.put("fire4thr",fire4.getThreshold());

        if (fire1.getRealNum()<fire1.getThreshold() && fire1.getRealNum()!=fire1.getThreshold()){
            backResult = backResult+"消防应急预案";
        }
        if (fire2.getRealNum()<fire2.getThreshold() && fire2.getRealNum()!=fire2.getThreshold()){
            if(!backResult.equals("，需加强")){
                backResult = backResult+"，";
            }
            backResult = backResult+"消防安全教育培训";
        }
        if (fire3.getRealNum()<fire3.getThreshold() && fire3.getRealNum()!=fire3.getThreshold()){
            if(!backResult.equals("，需加强")){
                backResult = backResult+"，";
            }
            backResult = backResult+"消防日常训练";
        }
        if ( fire4.getRealNum()<fire4.getThreshold() && fire4.getRealNum()!=fire4.getThreshold()){
            if(!backResult.equals("，需加强")){
                backResult = backResult+"，";
            }
            backResult = backResult+"消防器材保养";
        }
        if (backResult.equals("，需加强")){
            backResult = "。";
        }else {
            backResult = backResult+"工作。";
        }

        result.put("fires", newfires);
        result.put("backResult", backResult);
        return result;
    }
}
