package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.biz.service.impl.SourceFileServiceImpl;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCalledFeedbackDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalledFeedback;
import com.yeejoin.amos.boot.module.jcs.api.mapper.AlertCalledFeedbackMapper;
import com.yeejoin.amos.boot.module.jcs.api.mapper.PowerTransferMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertCalledFeedbackService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2021-09-08
 */
@Service
public class AlertCalledFeedbackServiceImpl extends BaseService<AlertCalledFeedbackDto, AlertCalledFeedback, AlertCalledFeedbackMapper> implements IAlertCalledFeedbackService {

    @Autowired
    SourceFileServiceImpl sourceFileService;

    @Autowired
    PowerTransferMapper powerTransferMapper;

    /**
     * 分页查询
     */
    public Page<AlertCalledFeedbackDto> queryForAlertCalledFeedbackPage(Page<AlertCalledFeedbackDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<AlertCalledFeedbackDto> queryForAlertCalledFeedbackList() {
        return this.queryForList("", false);
    }

    @Override
    public boolean handleFeedback(AlertCalledFeedbackDto model) {
        // 更新警情调派任务状态

        // 保存警情反馈
        model = createWithModel(model);

        // 保存警情反馈图片
        sourceFileService.saveAttachments(model.getSequenceNbr(), model.getAttachments());
        return true;
    }
}