package com.yeejoin.amos.knowledgebase.face.orm.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.knowledgebase.face.orm.entity.KnowledgeInteractionCount;

import java.util.List;

/**
 * <p>
  * 知识库内容交互计数表 Mapper 接口
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
public interface InteractionCountMapper extends BaseMapper<KnowledgeInteractionCount> {

    /**
     * 查询标签被所有文档的引用状况
     * @return
     */
    List<KnowledgeInteractionCount> queryTagQuoteAll();

    /**
     * 查询标签被发布文档的引用状况
     * @return
     */
    List<KnowledgeInteractionCount> queryTagQuotePublish();

    /**
     * 根据实体类型删除记录
     * @param entityType 类型
     * @return
     */
    int deleteByEntityType(String entityType);
}