package com.yeejoin.amos.maintenance.business.entity.mybatis;

import com.yeejoin.amos.maintenance.business.entity.mybatis.extend.RiskSourceExtend;
import lombok.Data;

import java.util.Date;

@Data
public class RiskSourceBo extends RiskSourceExtend {

    /**
     *
     */
    private Long id;

    /**
     * 名称
     */
    private String name;

    /**
     * 等级id
     */
    private Long riskLevel;

    /**
     * 风险等级值([])
     */
    private String riskLevelValue;

    /**
     * 编号
     */
    private String code;

    /**
     * 类型（厂区/区域/位置/风险）
     */
    private String riskType;

    /**
     * 辨识人id
     */
    private String userId;

    /**
     * 辨识方法id
     */
    private Long identificationMethodId;

    /**
     * 三维坐标信息：{"x":168.4586,"y":1.1004,"z":30.3959}
     */
    private String position3d;

    /**
     * 信息楼层
     */
    private String floor3d;

    /**
     * 室内室外：1 为室内，0为室外
     */
    private Boolean isIndoor;

    /**
     * 分类：固定/移动。
     */
    private String classify;

    /**
     * 创建人id
     */
    private String creatorId;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 所属组织编码
     */
    private String orgCode;

    /**
     *
     */
    private Date updateDate;

    /**
     *
     */
    private Long parentId;

    /**
     * 隐患排查状态：1 合格2不合格3漏检
     */
    private String checkStatus;

    /**
     * 是否有隐患
     */
    private Boolean isDanger;

    /**
     * 1一般隐患，2重大隐患
     */
    private String dangerLevel;

    private String belongDepartmentId;
}
